/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.util.ArrayList;
import org.apache.avalon.phoenix.containerkit.metadata.DependencyMetaData;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.framework.info.DependencyDescriptor;

class DependencyGraph {
    private DependencyGraph() {
    }

    public static String[] walkGraph(boolean forward, ComponentProfile[] blocks) {
        ArrayList result = new ArrayList();
        ArrayList done = new ArrayList();
        for (int i = 0; i < blocks.length; ++i) {
            DependencyGraph.visitBlock(blocks[i], blocks, forward, done, result);
        }
        return result.toArray(new String[0]);
    }

    private static void visitBlock(ComponentProfile block, ComponentProfile[] blocks, boolean forward, ArrayList done, ArrayList order) {
        String name = block.getMetaData().getName();
        if (done.contains(name)) {
            return;
        }
        done.add(name);
        if (forward) {
            DependencyGraph.visitDependencies(block, blocks, done, order);
        } else {
            DependencyGraph.visitReverseDependencies(block, blocks, done, order);
        }
        order.add(name);
    }

    private static void visitDependencies(ComponentProfile block, ComponentProfile[] blocks, ArrayList done, ArrayList order) {
        DependencyDescriptor[] descriptors = block.getInfo().getDependencies();
        for (int i = 0; i < descriptors.length; ++i) {
            String key = descriptors[i].getKey();
            DependencyMetaData[] dependencySet = block.getMetaData().getDependencies(key);
            for (int j = 0; j < dependencySet.length; ++j) {
                DependencyMetaData dependency = dependencySet[j];
                ComponentProfile other = DependencyGraph.getBlock(dependency.getProviderName(), blocks);
                DependencyGraph.visitBlock(other, blocks, true, done, order);
            }
        }
    }

    private static void visitReverseDependencies(ComponentProfile block, ComponentProfile[] blocks, ArrayList done, ArrayList order) {
        String name = block.getMetaData().getName();
        for (int i = 0; i < blocks.length; ++i) {
            ComponentProfile other = blocks[i];
            DependencyMetaData[] roles = other.getMetaData().getDependencies();
            for (int j = 0; j < roles.length; ++j) {
                String depends = roles[j].getProviderName();
                if (!depends.equals(name)) continue;
                DependencyGraph.visitBlock(other, blocks, false, done, order);
            }
        }
    }

    private static ComponentProfile getBlock(String name, ComponentProfile[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            if (!blocks[i].getMetaData().getName().equals(name)) continue;
            return blocks[i];
        }
        throw new IllegalStateException();
    }
}

