/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.transport.mailets;

import org.apache.james.test.mock.mailet.MockMail;
import org.apache.james.test.mock.mailet.MockMailContext;
import org.apache.james.test.mock.mailet.MockMailetConfig;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.Mailet;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

import junit.framework.TestCase;

public class ToProcessorTest extends TestCase {

    private MimeMessage mockedMimeMessage;

    private Mail mockedMail;

    private Mailet mailet;

    private String processor = null;

    private String notice = null;

    public ToProcessorTest(String arg0) throws UnsupportedEncodingException {
        super(arg0);
    }

    private void setProcessor(String processor) {
        this.processor = processor;
    }

    private void setNotice(String notice) {
        this.notice = notice;
    }

    private void setupMockedMail(MimeMessage m) throws ParseException {
        mockedMail = new MockMail();
        mockedMail.setMessage(m);
        mockedMail.setRecipients(Arrays.asList(new MailAddress[] {
                new MailAddress("test@james.apache.org"),
                new MailAddress("test2@james.apache.org") }));

    }

    private void setupMailet() throws MessagingException {
        mailet = new ToProcessor();
        MockMailetConfig mci = new MockMailetConfig("Test",
                new MockMailContext());
        if (processor != null) {
            mci.setProperty("processor", processor);
        }
        if (notice != null) {
            mci.setProperty("notice", notice);
        }
        mailet.init(mci);
    }

    // test if ToProcessor works
    public void testValidToProcessor() throws MessagingException {
        setProcessor("error");
        setNotice("error in message");
        setupMockedMail(mockedMimeMessage);
        setupMailet();

        mailet.service(mockedMail);

        assertEquals(processor, mockedMail.getState());
        assertEquals(notice, mockedMail.getErrorMessage());

    }

    // test if exception was thrown
    public void testExceptionThrown() throws MessagingException {
        boolean exceptionThrown = false;
        setProcessor(null);
        setNotice("error in message");
        setupMockedMail(mockedMimeMessage);

        try {
            setupMailet();
            mailet.service(mockedMail);
        } catch (MessagingException m) {
            exceptionThrown = true;
        }
        assertTrue(exceptionThrown);
    }

}
