/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.MethodIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XMethod;
import xjavadoc.XParameter;

public class PropertyTagsHandler
extends AbstractProgramElementTagsHandler {
    private static /* synthetic */ Class class$Lxdoclet$tagshandler$PropertyTagsHandler;

    public static XMethod getXMethodForMethodName(String methodName) {
        return PropertyTagsHandler.getXMethodForMethodName(methodName, false);
    }

    public static XMethod getXMethodForMethodName(String methodName, boolean superclasses) {
        if (methodName != null) {
            return PropertyTagsHandler.extractXMethod(XDocletTagSupport.getCurrentClass(), methodName, superclasses);
        }
        return null;
    }

    private static final XMethod extractXMethod(XClass clazz, String methodName) {
        return PropertyTagsHandler.extractXMethod(clazz, methodName, false);
    }

    private static final XMethod extractXMethod(XClass clazz, String methodName, boolean superclasses) {
        Collection methods = clazz.getMethods();
        MethodIterator i = XCollections.methodIterator((Collection)methods);
        while (i.hasNext()) {
            XMethod method = i.next();
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        if (superclasses) {
            clazz = clazz.getSuperclass();
            return PropertyTagsHandler.extractXMethod(clazz, methodName, superclasses);
        }
        return null;
    }

    public void forAllPropertiesWithTag(String template, Properties attributes) throws XDocletException {
        Log log = LogUtil.getLog(class$Lxdoclet$tagshandler$PropertyTagsHandler != null ? class$Lxdoclet$tagshandler$PropertyTagsHandler : (class$Lxdoclet$tagshandler$PropertyTagsHandler = PropertyTagsHandler.class$("xdoclet.tagshandler.PropertyTagsHandler")), "forAllPropertiesHavingTag");
        log.debug((Object)"in forAllPropertiesHavingTag");
        boolean superclasses = TypeConversionUtil.stringToBoolean(attributes.getProperty("superclasses"), true);
        String requiredTag = attributes.getProperty("tagName");
        if (requiredTag == null) {
            throw new XDocletException("missing required tag parameter in forAllPropertiesHavingTag");
        }
        XClass oldClass = XDocletTagSupport.getCurrentClass();
        ArrayList<String> already = new ArrayList<String>();
        do {
            XMethod oldCurrentMethod = XDocletTagSupport.getCurrentMethod();
            Collection methods = XDocletTagSupport.getCurrentClass().getMethods();
            MethodIterator j = XCollections.methodIterator((Collection)methods);
            while (j.hasNext()) {
                XMethod currentMethod = j.next();
                log.debug((Object)("looking at method " + currentMethod.getName()));
                if (currentMethod.getDoc().hasTag(requiredTag)) {
                    XDocletTagSupport.setCurrentMethod(currentMethod);
                    String propertyName = MethodTagsHandler.getMethodNameWithoutPrefixFor(currentMethod);
                    log.debug((Object)("property identified " + propertyName));
                    if (!already.contains(propertyName)) {
                        this.generate(template);
                        already.add(propertyName);
                    }
                }
                XDocletTagSupport.setCurrentMethod(oldCurrentMethod);
            }
            XDocletTagSupport.pushCurrentClass(XDocletTagSupport.getCurrentClass().getSuperclass());
        } while (superclasses && XDocletTagSupport.getCurrentClass() != null);
        XDocletTagSupport.setCurrentClass(oldClass);
    }

    public void ifHasGetMethodWithTag(String template, Properties attributes) throws XDocletException {
        XMethod getMethod = this.getGetMethodWithTag(attributes);
        if (getMethod != null) {
            XMethod oldMethod = XDocletTagSupport.getCurrentMethod();
            XDocletTagSupport.setCurrentMethod(getMethod);
            try {
                this.generate(template);
            }
            finally {
                Object var6_5 = null;
                XDocletTagSupport.setCurrentMethod(oldMethod);
            }
        }
    }

    public void ifHasSetMethodWithTag(String template, Properties attributes) throws XDocletException {
        XMethod setMethod = this.getSetMethodWithTag(attributes);
        if (setMethod != null) {
            XMethod oldMethod = XDocletTagSupport.getCurrentMethod();
            XDocletTagSupport.setCurrentMethod(setMethod);
            try {
                this.generate(template);
            }
            finally {
                Object var6_5 = null;
                XDocletTagSupport.setCurrentMethod(oldMethod);
            }
        }
    }

    public String propertyTypeWithTag(Properties attributes) throws XDocletException {
        XMethod getter = this.getGetMethodWithTag(attributes);
        if (getter != null) {
            return MethodTagsHandler.getMethodTypeFor(getter);
        }
        XMethod setter = this.getSetMethodWithTag(attributes);
        if (setter != null) {
            XParameter parameter = (XParameter)setter.getParameters().iterator().next();
            return parameter.getType().getQualifiedName();
        }
        throw new XDocletException("no current property found");
    }

    private final XMethod getGetMethodWithTag(Properties attributes) throws XDocletException {
        String requiredTag = attributes.getProperty("tagName");
        if (requiredTag == null) {
            throw new XDocletException("missing required tag parameter in forAllPropertiesHavingTag");
        }
        XMethod currentMethod = XDocletTagSupport.getCurrentMethod();
        if (currentMethod.getName().startsWith("get") || currentMethod.getName().startsWith("is")) {
            if (currentMethod.getDoc().hasTag(requiredTag)) {
                return currentMethod;
            }
            return null;
        }
        String attributeName = MethodTagsHandler.getMethodNameWithoutPrefixFor(currentMethod);
        XMethod getter = PropertyTagsHandler.getXMethodForMethodName("get" + attributeName);
        if (getter != null) {
            if (getter.getDoc().hasTag(requiredTag)) {
                return getter;
            }
            return null;
        }
        getter = PropertyTagsHandler.getXMethodForMethodName("is" + attributeName);
        if (getter != null && getter.getDoc().hasTag(requiredTag)) {
            return getter;
        }
        return null;
    }

    private final XMethod getSetMethodWithTag(Properties attributes) throws XDocletException {
        String requiredTag = attributes.getProperty("tagName");
        if (requiredTag == null) {
            throw new XDocletException("missing required tag parameter in forAllPropertiesHavingTag");
        }
        XMethod currentMethod = XDocletTagSupport.getCurrentMethod();
        if (currentMethod.getName().startsWith("set")) {
            if (currentMethod.getDoc().hasTag(requiredTag)) {
                return currentMethod;
            }
            return null;
        }
        String attributeName = MethodTagsHandler.getMethodNameWithoutPrefixFor(currentMethod);
        XMethod setter = PropertyTagsHandler.getXMethodForMethodName("set" + attributeName);
        if (setter != null && setter.getDoc().hasTag(requiredTag)) {
            return setter;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

