/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import xdoclet.DocletContext;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.XmlSubTask;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.ClassIterator;
import xjavadoc.MethodIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XJavaDoc;
import xjavadoc.XMember;
import xjavadoc.XMethod;

public class MethodTagsHandler
extends AbstractProgramElementTagsHandler {
    private static /* synthetic */ Class class$Lxdoclet$XDocletMessages;
    private static /* synthetic */ Class class$Lxdoclet$tagshandler$MethodTagsHandler;

    public static String getMethodTypeFor(XMethod method) {
        return MethodTagsHandler.getMethodTypeFor(method, false);
    }

    public static String getMethodTypeFor(XMethod method, boolean full_qualified) {
        boolean should_be_in_full_qualified_format = full_qualified || method.isReturnTypeDefinedInFullQualifiedFormat() || DocletContext.getInstance().getActiveSubTask() instanceof XmlSubTask;
        String return_type = should_be_in_full_qualified_format ? method.getReturnType().getQualifiedName() : method.getReturnType().getName();
        return return_type + method.getReturnDimensionAsString();
    }

    public static String getMethodNameWithoutPrefixFor(XMethod currentMethod) {
        String name = currentMethod.getName();
        if (name.startsWith("get") || name.startsWith("set")) {
            return name.substring(3);
        }
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        return name;
    }

    public static String getPropertyNameFor(XMethod method) {
        String name = MethodTagsHandler.getMethodNameWithoutPrefixFor(method);
        int len = name.length();
        if (len == 0) {
            return name;
        }
        if (len == 1) {
            return name.toLowerCase();
        }
        char c = name.charAt(0);
        if (c >= 'A' && c <= 'Z') {
            return (char)(c + 32) + name.substring(1);
        }
        return name;
    }

    public static boolean isGetter(String str) {
        return str.startsWith("get") || str.startsWith("is");
    }

    public static boolean isSetter(String str) {
        return str.startsWith("set");
    }

    public static boolean isGetterMethod(XMethod method) {
        String str = method.getName();
        return (str.startsWith("get") || str.startsWith("is")) && !method.getReturnType().equals(XJavaDoc.getInstance().getXClass("void")) && method.getParameters().size() == 0;
    }

    public static boolean isSetterMethod(XMethod method) {
        String str = method.getName();
        return str.startsWith("set") && method.getReturnType().equals(XJavaDoc.getInstance().getXClass("void")) && method.getParameters().size() == 1;
    }

    public static boolean hasMethod(XClass clazz, String methodName, String[] parameters, boolean setCurrentMethod) throws XDocletException {
        return AbstractProgramElementTagsHandler.hasExecutableMember(clazz, methodName, parameters, setCurrentMethod, 1);
    }

    public String getterPrefix() throws XDocletException {
        if (XDocletTagSupport.getCurrentMethod().getName().startsWith("get")) {
            return "get";
        }
        if (XDocletTagSupport.getCurrentMethod().getName().startsWith("is")) {
            return "is";
        }
        if (XDocletTagSupport.getCurrentMethod().getName().startsWith("set")) {
            String[] params = new String[]{XDocletTagSupport.getCurrentMethod().getReturnType().getQualifiedName()};
            if (MethodTagsHandler.hasMethod(XDocletTagSupport.getCurrentClass(), "is" + this.methodNameWithoutPrefix(), params, false)) {
                return "is";
            }
            return "get";
        }
        return "";
    }

    public String getterMethod() throws XDocletException {
        return this.getterPrefix() + this.methodNameWithoutPrefix();
    }

    public String setterMethod() throws XDocletException {
        return "set" + this.methodNameWithoutPrefix();
    }

    public void setCurrentMethod(String template, Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        XMethod oldMethod = XDocletTagSupport.getCurrentMethod();
        if (MethodTagsHandler.hasMethod(XDocletTagSupport.getCurrentClass(), methodName, parameters, true)) {
            this.generate(template);
        }
        XDocletTagSupport.setCurrentMethod(oldMethod);
    }

    public String modifiers() throws XDocletException {
        return this.modifiers(1);
    }

    public String methodComment(Properties attributes) throws XDocletException {
        return this.memberComment(attributes, 1);
    }

    public void ifHasMethodComment(String template) throws XDocletException {
        Properties attributes = new Properties();
        attributes.setProperty("no-comment-signs", "true");
        String comment = this.methodComment(attributes);
        if (!comment.trim().equals("")) {
            this.generate(template);
        }
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        return this.exceptionList(attributes, 1);
    }

    public void ifIsAbstract(String template, Properties attributes) throws XDocletException {
        if (this.isAbstract(attributes)) {
            this.generate(template);
        }
    }

    public void ifIsNotAbstract(String template, Properties attributes) throws XDocletException {
        if (!this.isAbstract(attributes)) {
            this.generate(template);
        }
    }

    public void ifReturnsVoid(String template, Properties attributes) throws XDocletException {
        if (this.returnsVoid(attributes)) {
            this.generate(template);
        }
    }

    public void ifDoesntReturnVoid(String template, Properties attributes) throws XDocletException {
        if (!this.returnsVoid(attributes)) {
            this.generate(template);
        }
    }

    public void forAllClassMethods(String template, Properties attributes) throws XDocletException {
        String typeName = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        Collection classes = AbstractProgramElementTagsHandler.getAllClasses();
        TreeSet methods = new TreeSet();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass clazz = i.next();
            if (typeName != null && !TypeTagsHandler.isOfType(clazz, typeName, extent)) continue;
            Collection classMethods = clazz.getMethods();
            methods.addAll(classMethods);
        }
        MethodIterator methodIterator = XCollections.methodIterator(methods);
        while (methodIterator.hasNext()) {
            XMethod current = methodIterator.next();
            XDocletTagSupport.setCurrentClass(current.getContainingClass());
            XDocletTagSupport.setCurrentMethod(current);
            this.generate(template);
        }
    }

    public void forAllMethods(String template, Properties attributes) throws XDocletException {
        this.forAllMembers(template, attributes, 1);
    }

    public void ifDoesntHaveMethodTag(String template, Properties attributes) throws XDocletException {
        if (!XDocletTagSupport.hasTag(attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasMethodTag(String template, Properties attributes) throws XDocletException {
        if (XDocletTagSupport.hasTag(attributes, 1)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreMethod(String template, Properties attributes) throws XDocletException {
        XMethod method = XDocletTagSupport.getCurrentMethod();
        this.generate(template);
        XDocletTagSupport.setCurrentMethod(method);
    }

    public void ifMethodTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (XDocletTagSupport.isTagValueEqual(attributes, 1)) {
            this.generate(template);
        }
    }

    public void ifMethodNameEquals(String template, Properties attributes) throws XDocletException {
        this.ifMethodNameEquals_Impl(template, attributes, true);
    }

    public void ifMethodNameNotEquals(String template, Properties attributes) throws XDocletException {
        this.ifMethodNameEquals_Impl(template, attributes, false);
    }

    public void ifMethodTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!XDocletTagSupport.isTagValueEqual(attributes, 1)) {
            this.generate(template);
        }
    }

    public String methodTagValue(Properties attributes) throws XDocletException {
        return XDocletTagSupport.dereferenceProperties(XDocletTagSupport.delimit(XDocletTagSupport.getTagValue(attributes, 1), attributes));
    }

    public void forAllMethodTags(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTags(template, attributes, 1, "ONLY_CALL_METHOD_NOT_NULL", new String[]{"forAllMethodTags"});
    }

    public void forAllMethodTagTokens(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTagTokens(template, attributes, 1);
    }

    public String firstSentenceDescriptionOfCurrentMethod() throws XDocletException {
        return this.firstSentenceDescriptionOfCurrentMember((XMember)XDocletTagSupport.getCurrentMethod());
    }

    public String methodType(Properties attributes) throws XDocletException {
        boolean full_qualified_format = TypeConversionUtil.stringToBoolean(attributes.getProperty("fullQualifiedFormat"), false);
        return MethodTagsHandler.getMethodTypeFor(XDocletTagSupport.getCurrentMethod(), full_qualified_format);
    }

    public void ifIsOfType(String template, Properties attributes) throws XDocletException {
        if (this.ifIsOfTypeImpl(template, attributes)) {
            this.generate(template);
        }
    }

    public void ifIsNotOfType(String template, Properties attributes) throws XDocletException {
        if (!this.ifIsOfTypeImpl(template, attributes)) {
            this.generate(template);
        }
    }

    public boolean ifIsOfTypeImpl(String template, Properties attributes) throws XDocletException {
        return this.methodType(attributes).equals(attributes.getProperty("type"));
    }

    public String methodName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)((Hashtable)attributes).get("value")) != null) {
            String m = XDocletTagSupport.getCurrentMethod().getName().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return XDocletTagSupport.getCurrentMethod() != null ? XDocletTagSupport.getCurrentMethod().getName() : "";
    }

    public String methodNameWithoutPrefix() throws XDocletException {
        return MethodTagsHandler.getMethodNameWithoutPrefixFor(XDocletTagSupport.getCurrentMethod());
    }

    public String currentMethodName() throws XDocletException {
        return XDocletTagSupport.getCurrentMethod().getName();
    }

    public String propertyName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor(XDocletTagSupport.getCurrentMethod());
    }

    public void ifHasMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, true);
    }

    public void ifDoesntHaveMethod(String template, Properties attributes) throws XDocletException {
        this.ifHasMethod_Impl(template, attributes, false);
    }

    public void ifIsGetter(String template, Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name != null) {
            if (MethodTagsHandler.isGetter(method_name)) {
                this.generate(template);
            }
        } else if (MethodTagsHandler.isGetterMethod(XDocletTagSupport.getCurrentMethod())) {
            this.generate(template);
        }
    }

    public void ifIsSetter(String template, Properties attributes) throws XDocletException {
        String method_name = attributes.getProperty("method");
        if (method_name != null) {
            if (MethodTagsHandler.isSetter(method_name)) {
                this.generate(template);
            }
        } else if (MethodTagsHandler.isSetterMethod(XDocletTagSupport.getCurrentMethod())) {
            this.generate(template);
        }
    }

    public void ifIsPublic(String template) throws XDocletException {
        if (XDocletTagSupport.getCurrentMethod().isPublic()) {
            this.generate(template);
        }
    }

    private final boolean isAbstract(Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("method");
        if (methodName == null) {
            return XDocletTagSupport.getCurrentMethod().isAbstract();
        }
        XMethod method = (XMethod)this.getXExecutableMemberForMemberName(methodName, true, 1);
        if (method == null) {
            throw new XDocletException(Translator.getString(class$Lxdoclet$XDocletMessages != null ? class$Lxdoclet$XDocletMessages : (class$Lxdoclet$XDocletMessages = MethodTagsHandler.class$("xdoclet.XDocletMessages")), "METHOD_NOT_FOUND", new String[]{methodName}));
        }
        return method.isAbstract();
    }

    private final boolean returnsVoid(Properties attributes) throws XDocletException {
        String methodName = attributes.getProperty("method");
        if (methodName == null) {
            return "void".equals(MethodTagsHandler.getMethodTypeFor(XDocletTagSupport.getCurrentMethod()));
        }
        XMethod method = (XMethod)this.getXExecutableMemberForMemberName(methodName, true, 1);
        if (method == null) {
            throw new XDocletException(Translator.getString(class$Lxdoclet$XDocletMessages != null ? class$Lxdoclet$XDocletMessages : (class$Lxdoclet$XDocletMessages = MethodTagsHandler.class$("xdoclet.XDocletMessages")), "METHOD_NOT_FOUND", new String[]{methodName}));
        }
        return "void".equals(MethodTagsHandler.getMethodTypeFor(method));
    }

    private final void ifMethodNameEquals_Impl(String template, Properties attributes, boolean condition) throws XDocletException {
        String method_name = attributes.getProperty("name");
        if (XDocletTagSupport.getCurrentMethod().getName().equals(method_name) == condition) {
            this.generate(template);
        }
    }

    private final void ifHasMethod_Impl(String template, Properties attributes, boolean hasMethod) throws XDocletException {
        Log log = LogUtil.getLog(class$Lxdoclet$tagshandler$MethodTagsHandler != null ? class$Lxdoclet$tagshandler$MethodTagsHandler : (class$Lxdoclet$tagshandler$MethodTagsHandler = MethodTagsHandler.class$("xdoclet.tagshandler.MethodTagsHandler")), "ifHasMethod_Impl");
        String methodName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("methodName=" + methodName));
            log.debug((Object)("parametersStr=" + parametersStr));
            log.debug((Object)("delimiter=" + delimiter));
            log.debug((Object)("hasMethod=" + hasMethod));
            log.debug((Object)("getCurrentClass()=" + XDocletTagSupport.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("parameters.length=" + parameters.length));
                log.debug((Object)("parameters[0]=" + parameters[0]));
            }
        }
        if (MethodTagsHandler.hasMethod(XDocletTagSupport.getCurrentClass(), methodName, parameters, false) == hasMethod) {
            log.debug((Object)"method found.");
            this.generate(template);
        } else {
            log.debug((Object)"method not found.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

