/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.ant.modulesbuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import xdoclet.ant.modulesbuilder.Module;
import xdoclet.ant.modulesbuilder.ModuleXmlParser;

public class ModulesGrandBuilderTask
extends Task {
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    private static ModuleXmlParser parser = new ModuleXmlParser();

    private static final boolean isModule(File file) {
        File module_build_xml = new File(file, "build.xml");
        return !file.getName().equalsIgnoreCase("build") && !file.getName().equalsIgnoreCase("cvs") && module_build_xml.exists();
    }

    private static final BuildException makeCircularException(String end, Stack stk) {
        String c;
        StringBuffer sb = new StringBuffer("Circular dependency: ");
        sb.append(end);
        do {
            c = (String)stk.pop();
            sb.append(" <- ");
            sb.append(c);
        } while (!c.equals(end));
        return new BuildException(new String(sb));
    }

    public final Vector topoSort(String root, Hashtable modules) throws BuildException {
        Vector ret = new Vector();
        Hashtable state = new Hashtable();
        Stack visiting = new Stack();
        this.tsort(root, modules, state, visiting, ret);
        Enumeration en = modules.keys();
        while (en.hasMoreElements()) {
            String cur_module = (String)en.nextElement();
            String st = (String)state.get(cur_module);
            if (st == null) {
                this.tsort(cur_module, modules, state, visiting, ret);
                continue;
            }
            if (st != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + cur_module);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        File base_dir = this.getProject().getBaseDir();
        File[] files = base_dir.listFiles();
        Hashtable<String, Module> modules = new Hashtable<String, Module>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory() && ModulesGrandBuilderTask.isModule(file)) {
                Module module = this.createModule(file);
                modules.put(module.getName(), module);
            }
            ++i;
        }
        Enumeration enumeration = modules.elements();
        while (enumeration.hasMoreElements()) {
            void var8_9;
            Module module = (Module)enumeration.nextElement();
            Vector sorted_modules = this.topoSort(module.getName(), modules);
            int curidx = 0;
            do {
                Module cur_module;
                if ((cur_module = (Module)sorted_modules.elementAt(curidx++)).isExecuted()) continue;
                this.executeModule(cur_module);
                cur_module.setExecuted(true);
            } while (!var8_9.getName().equals(module.getName()));
        }
    }

    private final void tsort(String root, Hashtable targets, Hashtable state, Stack visiting, Vector ret) throws BuildException {
        state.put(root, VISITING);
        visiting.push(root);
        Module module = (Module)targets.get(root);
        if (module == null) {
            StringBuffer sb = new StringBuffer("Module `");
            sb.append(root);
            sb.append("' does not exist. ");
            visiting.pop();
            if (!visiting.empty()) {
                String parent = (String)visiting.peek();
                sb.append("It is used from module `");
                sb.append(parent);
                sb.append("'.");
            }
            throw new BuildException(new String(sb));
        }
        Enumeration en = module.getDependencies();
        while (en.hasMoreElements()) {
            String cur = (String)en.nextElement();
            String m = (String)state.get(cur);
            if (m == null) {
                this.tsort(cur, targets, state, visiting, ret);
                continue;
            }
            if (m != VISITING) continue;
            throw ModulesGrandBuilderTask.makeCircularException(cur, visiting);
        }
        String p = (String)visiting.pop();
        if (root != p) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + root + " but got " + p);
        }
        state.put(root, VISITED);
        ret.addElement(module);
    }

    private final void executeModule(Module module) {
        Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), null);
        exe.setAntRun(((ProjectComponent)this).project);
        exe.setWorkingDirectory(module.getBaseDir());
        CommandlineJava cmdl = new CommandlineJava();
        Environment.Variable ant_home = new Environment.Variable();
        String env_ant_home = ((ProjectComponent)this).project.getProperty("env.ANT_HOME");
        if (env_ant_home != null) {
            ant_home.setKey("ant.home");
            ant_home.setValue(env_ant_home);
            cmdl.addSysproperty(ant_home);
        }
        Path classpath = cmdl.createClasspath(((ProjectComponent)this).project);
        classpath.setPath(System.getProperty("java.class.path"));
        cmdl.setClassname("org.apache.tools.ant.Main");
        exe.setCommandline(cmdl.getCommandline());
        try {
            int exit = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            if (exit != 0) {
                throw new BuildException("" + exit, this.location);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e, this.location);
        }
    }

    private final Module createModule(File file) {
        File module_xml = new File(file, "module.xml");
        Module module = null;
        if (module_xml.exists()) {
            try {
                FileInputStream module_xml_in = new FileInputStream(module_xml);
                module = parser.parse(module_xml_in);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            module = new Module();
        }
        module.setName(file.getName());
        module.setBaseDir(file);
        return module;
    }
}

