/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.connection;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import org.apache.avalon.cornerstone.blocks.connection.ConnectionMonitor;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandler;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;

class ConnectionRunner
implements Runnable {
    private Socket m_socket;
    private Thread m_thread;
    private List m_runners;
    private ConnectionHandlerFactory m_handlerFactory;
    private ConnectionMonitor monitor;
    private boolean m_finished;

    ConnectionRunner(Socket socket, List runners, ConnectionHandlerFactory handlerFactory, ConnectionMonitor monitor) {
        this.m_socket = socket;
        this.m_runners = runners;
        this.m_handlerFactory = handlerFactory;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws Exception {
        ConnectionRunner connectionRunner = this;
        synchronized (connectionRunner) {
            this.m_finished = true;
            if (null != this.m_thread) {
                this.m_thread.interrupt();
                this.m_thread = null;
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ConnectionRunner connectionRunner = this;
        synchronized (connectionRunner) {
            if (this.m_finished) {
                this.shutdownSocket();
                return;
            }
            this.m_thread = Thread.currentThread();
            this.m_runners.add(this);
        }
        ConnectionHandler handler = null;
        try {
            this.debugBanner(true);
            handler = this.m_handlerFactory.createConnectionHandler();
            handler.handleConnection(this.m_socket);
            this.debugBanner(false);
        }
        catch (Exception e) {
            String message = "Error handling connection";
            this.monitor.unexpectedException(this.getClass(), "Error handling connection", e);
        }
        if (null != handler) {
            this.m_handlerFactory.releaseConnectionHandler(handler);
        }
        this.shutdownSocket();
        ConnectionRunner connectionRunner2 = this;
        synchronized (connectionRunner2) {
            this.m_thread = null;
            this.m_runners.remove(this);
            this.notifyAll();
        }
    }

    private void debugBanner(boolean starting) {
        if (this.monitor.isDebugEnabled(this.getClass())) {
            String prefix = starting ? "Starting" : "Ending";
            String message = prefix + " connection on " + this.m_socket.getInetAddress().getHostAddress();
            this.monitor.debugMessage(this.getClass(), message);
        }
    }

    private void shutdownSocket() {
        try {
            this.m_socket.close();
        }
        catch (IOException ioe) {
            String message = "Error shutting down connection";
            this.monitor.shutdownSocketWarning(this.getClass(), "Error shutting down connection", ioe);
        }
    }
}

