/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.connection;

import java.net.ServerSocket;
import java.util.HashMap;
import org.apache.avalon.cornerstone.blocks.connection.Connection;
import org.apache.avalon.cornerstone.blocks.connection.ConnectionMonitor;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;
import org.apache.avalon.cornerstone.services.connection.ConnectionManager;
import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.excalibur.thread.ThreadPool;

public class AbstractConnectionManager
implements ConnectionManager {
    private final HashMap m_connections = new HashMap();
    protected ThreadManager m_threadManager;
    protected ConnectionMonitor monitor;

    public synchronized void connect(String name, ServerSocket socket, ConnectionHandlerFactory handlerFactory, ThreadPool threadPool) throws Exception {
        if (null != this.m_connections.get(name)) {
            String message = "Connection already exists with name " + name;
            throw new IllegalArgumentException(message);
        }
        if (0 == socket.getSoTimeout()) {
            socket.setSoTimeout(500);
        }
        Connection runner = new Connection(socket, handlerFactory, threadPool, this.monitor);
        this.m_connections.put(name, runner);
        threadPool.execute((Runnable)runner);
    }

    public void connect(String name, ServerSocket socket, ConnectionHandlerFactory handlerFactory) throws Exception {
        this.connect(name, socket, handlerFactory, this.m_threadManager.getDefaultThreadPool());
    }

    public void disconnect(String name) throws Exception {
        this.disconnect(name, false);
    }

    public synchronized void disconnect(String name, boolean tearDown) throws Exception {
        Connection connection = (Connection)this.m_connections.remove(name);
        if (connection == null) {
            String error = "Invalid request for the disconnection of an unrecognized connection name: " + name;
            throw new IllegalArgumentException(error);
        }
        connection.dispose();
    }

    public void dispose() {
        if (this.monitor.isDebugEnabled(this.getClass())) {
            this.monitor.debugMessage(this.getClass(), "disposal");
        }
        String[] names = this.m_connections.keySet().toArray(new String[0]);
        for (int i = 0; i < names.length; ++i) {
            try {
                this.disconnect(names[i]);
                continue;
            }
            catch (Exception e) {
                String message = "Error disconnecting " + names[i];
                this.monitor.unexpectedException(this.getClass(), message, e);
            }
        }
    }
}

