/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.scheduler;

import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.avalon.cornerstone.blocks.scheduler.PriorityQueue;

public final class BinaryHeap
implements PriorityQueue {
    public static final Comparator MIN_COMPARATOR = new MinComparator();
    public static final Comparator MAX_COMPARATOR = new MaxComparator();
    private static final int DEFAULT_CAPACITY = 13;
    private static final Comparator DEFAULT_COMPARATOR = MIN_COMPARATOR;
    private int m_size;
    private Object[] m_elements;
    private Comparator m_comparator;

    public BinaryHeap() {
        this(13, DEFAULT_COMPARATOR);
    }

    public BinaryHeap(int capacity) {
        this(capacity, DEFAULT_COMPARATOR);
    }

    public BinaryHeap(Comparator comparator) {
        this(13, comparator);
    }

    public BinaryHeap(int capacity, Comparator comparator) {
        this.m_elements = new Object[capacity + 1];
        this.m_comparator = comparator;
    }

    public BinaryHeap(boolean isMinHeap) {
        this(13, isMinHeap);
    }

    public BinaryHeap(int capacity, boolean isMinHeap) {
        this(capacity, isMinHeap ? MIN_COMPARATOR : MAX_COMPARATOR);
    }

    public void clear() {
        this.m_size = 0;
    }

    public boolean isEmpty() {
        return 0 == this.m_size;
    }

    public boolean isFull() {
        return this.m_elements.length == this.m_size + 1;
    }

    public int size() {
        return this.m_size;
    }

    public void insert(Object element) {
        if (this.isFull()) {
            this.grow();
        }
        this.percolateUpHeap(element);
    }

    public Object peek() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.m_elements[1];
    }

    public Object pop() throws NoSuchElementException {
        Object result = this.peek();
        this.m_elements[1] = this.m_elements[this.m_size--];
        this.m_elements[this.m_size + 1] = null;
        if (this.m_size != 0) {
            this.percolateDownHeap(1);
        }
        return result;
    }

    private void percolateDownHeap(int index) {
        Object element = this.m_elements[index];
        int hole = index;
        int child = hole << 1;
        while (child <= this.m_size) {
            if (child != this.m_size && this.m_comparator.compare(this.m_elements[child + 1], this.m_elements[child]) < 0) {
                ++child;
            }
            if (this.m_comparator.compare(this.m_elements[child], element) >= 0) break;
            this.m_elements[hole] = this.m_elements[child];
            hole = child;
            child = hole << 1;
        }
        this.m_elements[hole] = element;
    }

    private void percolateUpHeap(Object element) {
        int hole = ++this.m_size;
        int next = hole >> 1;
        this.m_elements[hole] = element;
        while (hole > 1 && this.m_comparator.compare(element, this.m_elements[next]) < 0) {
            this.m_elements[hole] = this.m_elements[next];
            hole = next;
            next = hole >> 1;
        }
        this.m_elements[hole] = element;
    }

    private void grow() {
        Object[] elements = new Object[this.m_elements.length * 2];
        System.arraycopy(this.m_elements, 0, elements, 0, this.m_elements.length);
        this.m_elements = elements;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        for (int i = 1; i < this.m_size + 1; ++i) {
            if (i != 1) {
                sb.append(", ");
            }
            sb.append(this.m_elements[i]);
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static final class MaxComparator
    implements Comparator {
        private MaxComparator() {
        }

        public final int compare(Object lhs, Object rhs) {
            return ((Comparable)rhs).compareTo(lhs);
        }
    }

    private static final class MinComparator
    implements Comparator {
        private MinComparator() {
        }

        public final int compare(Object lhs, Object rhs) {
            return ((Comparable)lhs).compareTo(rhs);
        }
    }
}

