/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.containerkit.lifecycle;

import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.phoenix.containerkit.lifecycle.LifecycleException;
import org.apache.avalon.phoenix.containerkit.lifecycle.ResourceProvider;
import org.apache.excalibur.instrument.InstrumentManageable;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.Instrumentable;

public class LifecycleHelper
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$containerkit$lifecycle$LifecycleHelper == null ? (class$org$apache$avalon$phoenix$containerkit$lifecycle$LifecycleHelper = LifecycleHelper.class$("org.apache.avalon.phoenix.containerkit.lifecycle.LifecycleHelper")) : class$org$apache$avalon$phoenix$containerkit$lifecycle$LifecycleHelper));
    private static final int STAGE_CREATE = 0;
    private static final int STAGE_LOGGER = 1;
    private static final int STAGE_INSTRUMENTMGR = 2;
    private static final int STAGE_CONTEXT = 3;
    private static final int STAGE_COMPOSE = 4;
    private static final int STAGE_CONFIG = 5;
    private static final int STAGE_PARAMETER = 6;
    private static final int STAGE_INIT = 7;
    private static final int STAGE_INSTRUMENTABLE = 8;
    private static final int STAGE_START = 9;
    private static final int STAGE_STOP = 10;
    private static final int STAGE_DISPOSE = 11;
    private static final int STAGE_DESTROY = 12;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$containerkit$lifecycle$LifecycleHelper;

    public Object startup(String name, Object entry, ResourceProvider provider) throws LifecycleException {
        int stage = 0;
        try {
            stage = 0;
            this.notice(name, stage);
            Object object = provider.createObject(entry);
            InstrumentManager instrumentManager = provider.createInstrumentManager(entry);
            stage = 1;
            if (object instanceof LogEnabled) {
                this.notice(name, stage);
                Logger logger = provider.createLogger(entry);
                ContainerUtil.enableLogging((Object)object, (Logger)logger);
            }
            stage = 2;
            if (object instanceof InstrumentManageable) {
                this.notice(name, stage);
                ((InstrumentManageable)object).setInstrumentManager(instrumentManager);
            }
            stage = 3;
            if (object instanceof Contextualizable) {
                this.notice(name, stage);
                Context context = provider.createContext(entry);
                ContainerUtil.contextualize((Object)object, (Context)context);
            }
            stage = 4;
            if (object instanceof Serviceable) {
                this.notice(name, stage);
                ServiceManager manager = provider.createServiceManager(entry);
                ContainerUtil.service((Object)object, (ServiceManager)manager);
            } else if (object instanceof Composable) {
                this.notice(name, stage);
                ComponentManager componentManager = provider.createComponentManager(entry);
                ContainerUtil.compose((Object)object, (ComponentManager)componentManager);
            }
            stage = 5;
            if (object instanceof Configurable) {
                this.notice(name, stage);
                Configuration configuration = provider.createConfiguration(entry);
                ContainerUtil.configure((Object)object, (Configuration)configuration);
            }
            stage = 6;
            if (object instanceof Parameterizable) {
                this.notice(name, stage);
                Parameters parameters = provider.createParameters(entry);
                ContainerUtil.parameterize((Object)object, (Parameters)parameters);
            }
            stage = 7;
            if (object instanceof Initializable) {
                this.notice(name, stage);
                ContainerUtil.initialize((Object)object);
            }
            stage = 8;
            if (object instanceof Instrumentable) {
                this.notice(name, stage);
                String instrumentableName = provider.createInstrumentableName(entry);
                Instrumentable instrumentable = (Instrumentable)object;
                instrumentable.setInstrumentableName(instrumentableName);
                instrumentManager.registerInstrumentable(instrumentable, instrumentableName);
            }
            stage = 9;
            if (object instanceof Startable) {
                this.notice(name, stage);
                ContainerUtil.start((Object)object);
            }
            return object;
        }
        catch (Throwable t) {
            this.fail(name, stage, t);
            return null;
        }
    }

    public void shutdown(String name, Object object) throws LifecycleException {
        int stage = 0;
        Throwable failure = null;
        if (object instanceof Startable) {
            this.notice(name, 10);
            try {
                ContainerUtil.stop((Object)object);
            }
            catch (Throwable t) {
                this.safeFail(name, 10, t);
                failure = t;
                stage = 10;
            }
        }
        if (object instanceof Disposable) {
            this.notice(name, 11);
            try {
                ContainerUtil.dispose((Object)object);
            }
            catch (Throwable t) {
                this.safeFail(name, 11, t);
                failure = t;
                stage = 11;
            }
        }
        this.notice(name, 12);
        if (null != failure) {
            this.fail(name, stage, failure);
        }
    }

    private void notice(String name, int stage) {
        if (this.getLogger().isDebugEnabled()) {
            String message = REZ.getString("lifecycle.stage.notice", (Object)name, (Object)new Integer(stage));
            this.getLogger().debug(message);
        }
    }

    private void safeFail(String name, int stage, Throwable t) {
        String reason = t.toString();
        String message = REZ.getString("lifecycle.fail.error", (Object)name, (Object)new Integer(stage), (Object)reason);
        this.getLogger().error(message);
    }

    private void fail(String name, int stage, Throwable t) throws LifecycleException {
        String reason = t.toString();
        String message = REZ.getString("lifecycle.fail.error", (Object)name, (Object)new Integer(stage), (Object)reason);
        this.getLogger().error(message);
        throw new LifecycleException(message, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

