/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.datasources;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.cornerstone.services.datasources.DataSourceSelector;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.service.ServiceException;

public class DefaultDataSourceSelector
extends AbstractLogEnabled
implements DataSourceSelector,
Contextualizable,
Configurable,
Initializable,
Disposable {
    private Configuration m_configuration;
    private Map m_dataSources;
    private String m_blockName;

    public void contextualize(Context context) throws ContextException {
        try {
            this.m_blockName = (String)context.get((Object)"urn:avalon:name");
        }
        catch (Throwable e) {
            try {
                this.m_blockName = (String)context.get((Object)"block.name");
            }
            catch (Throwable ee) {
                this.m_blockName = "DataSourceSelector/" + System.identityHashCode((Object)this);
            }
        }
    }

    public void configure(Configuration configuration) {
        this.m_configuration = configuration;
    }

    public void initialize() throws Exception {
        this.m_dataSources = new HashMap();
        Configuration[] dataSourceConfs = this.getDataSourceConfig();
        for (int i = 0; i < dataSourceConfs.length; ++i) {
            Configuration dataSourceConf = dataSourceConfs[i];
            String name = dataSourceConf.getAttribute("name");
            String clazz = dataSourceConf.getAttribute("class");
            String driver = dataSourceConf.getChild("driver", true).getValue("");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            DataSourceComponent component = null;
            if (null == classLoader) {
                if (!"".equals(driver)) {
                    Class.forName(driver, true, Thread.currentThread().getContextClassLoader());
                }
                component = (DataSourceComponent)Class.forName(clazz).newInstance();
            } else {
                if (!"".equals(driver)) {
                    classLoader.loadClass(driver);
                }
                component = (DataSourceComponent)classLoader.loadClass(clazz).newInstance();
            }
            if (component instanceof LogEnabled) {
                this.setupLogger(component, name);
            }
            component.configure(dataSourceConf);
            this.m_dataSources.put(name, component);
            if (!this.getLogger().isInfoEnabled()) continue;
            this.getLogger().info("DataSource " + name + " ready");
        }
    }

    private Configuration[] getDataSourceConfig() {
        Configuration head = this.m_configuration.getChild("data-sources");
        if (0 != head.getChildren().length) {
            String message = "WARNING: Child node <data-sources/> in configuration of component named " + this.m_blockName + " has been deprecated. Please put <data-source/> elements" + " in root configuration element";
            this.getLogger().warn(message);
            System.out.println(message);
            return head.getChildren("data-source");
        }
        return this.m_configuration.getChildren("data-source");
    }

    public void dispose() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("disposal");
        }
        Iterator keys = this.m_dataSources.keySet().iterator();
        while (keys.hasNext()) {
            DataSourceComponent dsc = (DataSourceComponent)this.m_dataSources.get(keys.next());
            if (!(dsc instanceof Disposable)) continue;
            ((Disposable)dsc).dispose();
        }
    }

    public boolean isSelectable(Object hint) {
        return this.m_dataSources.containsKey(hint);
    }

    public Object select(Object hint) throws ServiceException {
        Object component = this.m_dataSources.get(hint);
        if (null == component) {
            throw new ServiceException(hint.toString(), "Unable to provide DataSourceComponent for " + hint);
        }
        return component;
    }

    public void release(Object component) {
    }
}

