/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Map;
import org.apache.velocity.util.introspection.MethodMap;

public class ClassMap {
    private static final CacheMiss CACHE_MISS = new CacheMiss();
    private static final Object OBJECT = new Object();
    private Class clazz;
    private Map methodCache = new Hashtable();
    private MethodMap methodMap = new MethodMap();

    Class getCachedClass() {
        return this.clazz;
    }

    public Method findMethod(String name, Object[] params) {
        String methodKey = ClassMap.makeMethodKey(name, params);
        Object cacheEntry = this.methodCache.get(methodKey);
        if (cacheEntry == CACHE_MISS) {
            return null;
        }
        if (cacheEntry == null) {
            cacheEntry = this.methodMap.find(name, params);
            if (cacheEntry == null) {
                this.methodCache.put(methodKey, CACHE_MISS);
            } else {
                this.methodCache.put(methodKey, cacheEntry);
            }
        }
        return (Method)cacheEntry;
    }

    private void populateMethodCache() {
        Method[] methods = ClassMap.getAccessibleMethods(this.clazz);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            Method publicMethod = ClassMap.getPublicMethod(method);
            if (publicMethod != null) {
                this.methodMap.add(publicMethod);
                this.methodCache.put(this.makeMethodKey(publicMethod), publicMethod);
            }
            ++i;
        }
    }

    private String makeMethodKey(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuffer methodKey = new StringBuffer().append(method.getName());
        int j = 0;
        while (j < parameterTypes.length) {
            if (parameterTypes[j].isPrimitive()) {
                if (parameterTypes[j].equals(Boolean.TYPE)) {
                    methodKey.append("java.lang.Boolean");
                } else if (parameterTypes[j].equals(Byte.TYPE)) {
                    methodKey.append("java.lang.Byte");
                } else if (parameterTypes[j].equals(Character.TYPE)) {
                    methodKey.append("java.lang.Character");
                } else if (parameterTypes[j].equals(Double.TYPE)) {
                    methodKey.append("java.lang.Double");
                } else if (parameterTypes[j].equals(Float.TYPE)) {
                    methodKey.append("java.lang.Float");
                } else if (parameterTypes[j].equals(Integer.TYPE)) {
                    methodKey.append("java.lang.Integer");
                } else if (parameterTypes[j].equals(Long.TYPE)) {
                    methodKey.append("java.lang.Long");
                } else if (parameterTypes[j].equals(Short.TYPE)) {
                    methodKey.append("java.lang.Short");
                }
            } else {
                methodKey.append(parameterTypes[j].getName());
            }
            ++j;
        }
        return methodKey.toString();
    }

    private static String makeMethodKey(String method, Object[] params) {
        StringBuffer methodKey = new StringBuffer().append(method);
        int j = 0;
        while (j < params.length) {
            if (params[j] == null) {
                params[j] = OBJECT;
            }
            methodKey.append(params[j].getClass().getName());
            ++j;
        }
        return methodKey.toString();
    }

    private static Method[] getAccessibleMethods(Class clazz) {
        Method[] methods = clazz.getMethods();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return methods;
        }
        MethodInfo[] methodInfos = new MethodInfo[methods.length];
        int i = methods.length;
        while (i-- > 0) {
            methodInfos[i] = new MethodInfo(methods[i]);
        }
        int upcastCount = ClassMap.getAccessibleMethods(clazz, methodInfos, 0);
        if (upcastCount < methods.length) {
            methods = new Method[upcastCount];
        }
        int j = 0;
        int i2 = 0;
        while (i2 < methodInfos.length) {
            MethodInfo methodInfo = methodInfos[i2];
            if (methodInfo.upcast) {
                methods[j++] = methodInfo.method;
            }
            ++i2;
        }
        return methods;
    }

    private static int getAccessibleMethods(Class clazz, MethodInfo[] methodInfos, int upcastCount) {
        Class superclazz;
        int l = methodInfos.length;
        if (Modifier.isPublic(clazz.getModifiers())) {
            int i = 0;
            while (i < l && upcastCount < l) {
                try {
                    MethodInfo methodInfo = methodInfos[i];
                    if (!methodInfo.upcast) {
                        methodInfo.tryUpcasting(clazz);
                    }
                    ++upcastCount;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                ++i;
            }
            if (upcastCount == l) {
                return upcastCount;
            }
        }
        if ((superclazz = clazz.getSuperclass()) != null && (upcastCount = ClassMap.getAccessibleMethods(superclazz, methodInfos, upcastCount)) == l) {
            return upcastCount;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = interfaces.length;
        while (i-- > 0) {
            if ((upcastCount = ClassMap.getAccessibleMethods(interfaces[i], methodInfos, upcastCount)) != l) continue;
            return upcastCount;
        }
        return upcastCount;
    }

    public static Method getPublicMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz.getModifiers() & 1) != 0) {
            return method;
        }
        return ClassMap.getPublicMethod(clazz, method.getName(), method.getParameterTypes());
    }

    private static Method getPublicMethod(Class clazz, String name, Class[] paramTypes) {
        Method superclazzMethod;
        if ((clazz.getModifiers() & 1) != 0) {
            try {
                return clazz.getMethod(name, paramTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        Class superclazz = clazz.getSuperclass();
        if (superclazz != null && (superclazzMethod = ClassMap.getPublicMethod(superclazz, name, paramTypes)) != null) {
            return superclazzMethod;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            Method interfaceMethod = ClassMap.getPublicMethod(interfaces[i], name, paramTypes);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            ++i;
        }
        return null;
    }

    public ClassMap(Class clazz) {
        this.clazz = clazz;
        this.populateMethodCache();
    }

    private static final class CacheMiss {
        CacheMiss() {
        }
    }

    private static final class MethodInfo {
        Method method = null;
        String name;
        Class[] parameterTypes;
        boolean upcast;

        void tryUpcasting(Class clazz) throws NoSuchMethodException {
            this.method = clazz.getMethod(this.name, this.parameterTypes);
            this.name = null;
            this.parameterTypes = null;
            this.upcast = true;
        }

        MethodInfo(Method method) {
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            this.upcast = false;
        }
    }
}

