/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.test.BaseTestCase;
import org.apache.velocity.test.TemplateTestBase;

public class ContextSafetyTestCase
extends BaseTestCase
implements TemplateTestBase {
    public static Test suite() {
        return new ContextSafetyTestCase();
    }

    public void runTest() {
        Vector<String> v = new Vector<String>();
        v.addElement(new String("vector hello 1"));
        v.addElement(new String("vector hello 2"));
        v.addElement(new String("vector hello 3"));
        String[] strArray = new String[]{"array hello 1", "array hello 2", "array hello 3"};
        VelocityContext context = new VelocityContext();
        try {
            BaseTestCase.assureResultsDirectoryExists("../test/templates/results");
            Template template = RuntimeSingleton.getTemplate(BaseTestCase.getFileName(null, "context_safety", "vm"));
            FileOutputStream fos1 = new FileOutputStream(BaseTestCase.getFileName("../test/templates/results", "context_safety1", "res"));
            FileOutputStream fos2 = new FileOutputStream(BaseTestCase.getFileName("../test/templates/results", "context_safety2", "res"));
            BufferedWriter writer1 = new BufferedWriter(new OutputStreamWriter(fos1));
            BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(fos2));
            context.put("vector", v);
            template.merge(context, writer1);
            ((Writer)writer1).flush();
            ((Writer)writer1).close();
            context.put("vector", strArray);
            template.merge(context, writer2);
            ((Writer)writer2).flush();
            ((Writer)writer2).close();
            if (!this.isMatch("../test/templates/results", "../test/templates/compare", "context_safety1", "res", "cmp") || !this.isMatch("../test/templates/results", "../test/templates/compare", "context_safety2", "res", "cmp")) {
                Assert.fail((String)"Output incorrect.");
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public ContextSafetyTestCase() {
        super("ContextSafetyTestCase");
        try {
            Velocity.setProperty("file.resource.loader.path", "../test/templates");
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup ContextSafetyTestCase!");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

