/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.introspection.IntrospectionCacheData;

public class ASTMethod
extends SimpleNode {
    private String methodName = "";
    private int paramCount = 0;
    private Object[] params;

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object init(InternalContextAdapter context, Object data) throws Exception {
        super.init(context, data);
        this.methodName = this.getFirstToken().image;
        this.paramCount = this.jjtGetNumChildren() - 1;
        this.params = new Object[this.paramCount];
        return data;
    }

    private Method doIntrospection(InternalContextAdapter context, Class data) throws MethodInvocationException, Exception {
        int j = 0;
        while (j < this.paramCount) {
            this.params[j] = this.jjtGetChild(j + 1).value(context);
            ++j;
        }
        Method m = this.rsvc.getIntrospector().getMethod(data, this.methodName, this.params);
        return m;
    }

    public Object execute(Object o, InternalContextAdapter context) throws MethodInvocationException {
        Method method = null;
        try {
            IntrospectionCacheData icd = context.icacheGet(this);
            Class<?> c = o.getClass();
            if (icd != null && icd.contextData == c) {
                int j = 0;
                while (j < this.paramCount) {
                    this.params[j] = this.jjtGetChild(j + 1).value(context);
                    ++j;
                }
                method = (Method)icd.thingy;
            } else {
                method = this.doIntrospection(context, c);
                if (method != null) {
                    icd = new IntrospectionCacheData();
                    icd.contextData = c;
                    icd.thingy = method;
                    context.icachePut(this, icd);
                }
            }
            if (method == null) {
                return null;
            }
        }
        catch (MethodInvocationException mie) {
            throw mie;
        }
        catch (Exception e) {
            this.rsvc.error("ASTMethod.execute() : exception from introspection : " + e);
            return null;
        }
        try {
            Object obj = method.invoke(o, this.params);
            if (obj == null && method.getReturnType() == Void.TYPE) {
                return new String("");
            }
            return obj;
        }
        catch (InvocationTargetException ite) {
            EventCartridge ec = context.getEventCartridge();
            if (ec != null && ite.getTargetException() instanceof Exception) {
                try {
                    return ec.methodException(o.getClass(), this.methodName, (Exception)ite.getTargetException());
                }
                catch (Exception e) {
                    throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + o.getClass() + " threw exception " + e.getClass() + " : " + e.getMessage(), e, this.methodName);
                }
            }
            throw new MethodInvocationException("Invocation of method '" + this.methodName + "' in  " + o.getClass() + " threw exception " + ite.getTargetException().getClass() + " : " + ite.getTargetException().getMessage(), ite.getTargetException(), this.methodName);
        }
        catch (Exception e) {
            this.rsvc.error("ASTMethod.execute() : exception invoking method '" + this.methodName + "' in " + o.getClass() + " : " + e);
            return null;
        }
    }

    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(Parser p, int id) {
        super(p, id);
    }
}

