/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io.rotate;

import java.io.File;
import java.io.IOException;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.rotate.FileStrategy;
import org.apache.log.output.io.rotate.RotateStrategy;

public class RotatingFileTarget
extends FileTarget {
    private RotateStrategy m_rotateStrategy;
    private FileStrategy m_fileStrategy;

    protected synchronized void rotate() throws IOException {
        this.close();
        File file = this.m_fileStrategy.nextFile();
        this.setFile(file, false);
        this.openFile();
    }

    protected synchronized void write(String data) {
        super.write(data);
        boolean rotate = this.m_rotateStrategy.isRotationNeeded(data, this.getFile());
        if (rotate) {
            try {
                this.rotate();
            }
            catch (IOException ioe) {
                this.getErrorHandler().error("Error rotating file", ioe, null);
            }
        }
    }

    public RotatingFileTarget(Formatter formatter, RotateStrategy rotateStrategy, FileStrategy fileStrategy) throws IOException {
        super(null, false, formatter);
        this.m_rotateStrategy = rotateStrategy;
        this.m_fileStrategy = fileStrategy;
        this.rotate();
    }
}

