/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.StreamTarget;

public class FileTarget
extends StreamTarget {
    private File m_file;
    private boolean m_append;

    protected synchronized void setFile(File file, boolean append) throws IOException {
        if (file == null) {
            throw new NullPointerException("file property must not be null");
        }
        if (this.isOpen()) {
            throw new IOException("target must be closed before file property can be set");
        }
        this.m_append = append;
        this.m_file = file;
    }

    protected synchronized void openFile() throws IOException {
        File file;
        File parent;
        if (this.isOpen()) {
            this.close();
        }
        if ((parent = (file = this.getFile().getCanonicalFile()).getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file.getPath(), this.m_append);
        this.setOutputStream(outputStream);
        this.open();
    }

    protected synchronized File getFile() {
        return this.m_file;
    }

    public FileTarget(File file, boolean append, Formatter formatter) throws IOException {
        super(null, formatter);
        if (file != null) {
            this.setFile(file, append);
            this.openFile();
        }
    }
}

