/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.sockets;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import sun.security.provider.Sun;

public class SSLFactoryBuilder
extends AbstractLogEnabled
implements Configurable,
Contextualizable,
Disposable,
Initializable {
    private File m_baseDirectory;
    private File m_keystoreFile;
    private String m_keystorePassword;
    private String m_keyPassword;
    private String m_protocol;
    private String m_provider;
    private String m_keystoreFormat;
    private SSLContext m_ctx;

    public void contextualize(Context context) throws ContextException {
        try {
            this.m_baseDirectory = (File)context.get((Object)"urn:avalon:home");
        }
        catch (ContextException ce) {
            this.m_baseDirectory = (File)context.get((Object)"app.home");
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration storeConfig = configuration.getChild("keystore");
        String fileName = storeConfig.getChild("file").getValue("conf/keystore");
        File configuredFile = new File(fileName);
        this.m_keystoreFile = !configuredFile.isAbsolute() ? new File(this.m_baseDirectory, fileName) : configuredFile;
        this.m_keystorePassword = storeConfig.getChild("password").getValue(null);
        this.m_keyPassword = storeConfig.getChild("key-password").getValue(null);
        this.m_provider = storeConfig.getChild("algorithm").getValue("SunX509");
        this.m_keystoreFormat = storeConfig.getChild("type").getValue("JKS");
        this.m_protocol = configuration.getChild("protocol").getValue(storeConfig.getChild("protocol").getValue("TLS"));
    }

    public SSLSocketFactory buildSocketFactory() {
        return this.m_ctx.getSocketFactory();
    }

    public SSLServerSocketFactory buildServerSocketFactory() {
        return this.m_ctx.getServerSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IOException, GeneralSecurityException {
        FileInputStream keyStream = new FileInputStream(this.m_keystoreFile);
        try {
            this.m_ctx = SSLFactoryBuilder.makeContext(keyStream, this.m_keystorePassword, this.m_keyPassword, this.m_protocol, this.m_provider, this.m_keystoreFormat);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                keyStream.close();
            }
            catch (IOException e) {
                this.getLogger().error("Error keyStream.close failed", (Throwable)e);
            }
            throw throwable;
        }
        try {
            keyStream.close();
        }
        catch (IOException e) {
            this.getLogger().error("Error keyStream.close failed", (Throwable)e);
        }
    }

    public void dispose() {
        this.m_keystorePassword = null;
        this.m_keyPassword = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLContext makeContext(InputStream keyStream, String keystorePassword, String keyPassword, String protocol, String provider, String keystoreFormat) throws IOException, GeneralSecurityException {
        KeyStore keystore = SSLFactoryBuilder.loadKeystore(keyStream, keystorePassword, keystoreFormat);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(provider);
        char[] passChars = keyPassword != null ? keyPassword.toCharArray() : new char[]{};
        try {
            kmf.init(keystore, passChars);
        }
        finally {
            Arrays.fill(passChars, '\u0000');
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(provider);
        tmf.init(keystore);
        SSLContext result = SSLContext.getInstance(protocol);
        result.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeystore(InputStream keyStream, String passphrase, String keystoreFormat) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(keystoreFormat);
        if (passphrase != null) {
            char[] passChars = passphrase.toCharArray();
            try {
                ks.load(keyStream, passChars);
            }
            finally {
                Arrays.fill(passChars, '\u0000');
            }
        } else {
            ks.load(keyStream, null);
        }
        return ks;
    }

    static {
        Security.addProvider(new Sun());
        Security.addProvider((java.security.Provider)new Provider());
    }
}

