/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.ant;

import java.io.File;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import xjavadoc.SourceSet;
import xjavadoc.XJavaDoc;

public abstract class XJavadocTask
extends Task {
    private final LinkedList _fileSets = new LinkedList();

    public void setSourcepath(Path path) {
        throw new BuildException("The 'sourcepath' attribute can not be used anymore.  Use <fileset> to define the files to parse");
    }

    public final void execute() throws BuildException {
        XJavaDoc.getInstance().reset();
        try {
            try {
                this.validateOptions();
                SourceSet[] sourceSets = new SourceSet[this._fileSets.size()];
                int i = 0;
                while (i < this._fileSets.size()) {
                    FileSet fs = (FileSet)this._fileSets.get(i);
                    File dir = fs.getDir(this.project);
                    DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                    String[] files = ds.getIncludedFiles();
                    sourceSets[i] = new SourceSet(dir, files);
                    XJavaDoc.getInstance().addSourceSet(sourceSets[i]);
                    ++i;
                }
                this.start();
            }
            catch (OutOfMemoryError e) {
                System.err.println(e.getMessage());
                XJavaDoc.printMemoryStatus();
                System.err.println("Try to increase heap size. Can be done by defining ANT_OPTS=-Xmx640m");
                System.err.println("See the JDK tooldocs.");
                throw new BuildException(e.getMessage(), (Throwable)e, this.location);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new BuildException("Unexpected error", t, this.location);
            }
            Object var8_9 = null;
            XJavaDoc.getInstance().printLogMessages(System.out, 0);
            XJavaDoc.getInstance().printLogMessages(System.out, 1);
            XJavaDoc.getInstance().reset();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            XJavaDoc.getInstance().printLogMessages(System.out, 0);
            XJavaDoc.getInstance().printLogMessages(System.out, 1);
            XJavaDoc.getInstance().reset();
            System.gc();
            throw throwable;
        }
        System.gc();
    }

    public void addFileset(FileSet set) {
        this._fileSets.add(set);
    }

    protected abstract void start() throws BuildException;

    protected void validateOptions() throws BuildException {
        if (this._fileSets.size() == 0) {
            throw new BuildException("At least one fileset must be specified", this.location);
        }
    }
}

