/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.util.HashMap;
import xjavadoc.XJavaDocException;
import xjavadoc.XTag;

public abstract class XTagFactory {
    private static final String DEFAULT_FACTORY = "xjavadoc.DefaultXTagFactory";
    private static final HashMap _factories;

    public static XTagFactory getInstance(String className) throws XJavaDocException {
        XTagFactory result = (XTagFactory)_factories.get(className);
        if (result == null) {
            try {
                result = (XTagFactory)Class.forName(className).newInstance();
                _factories.put(className, result);
            }
            catch (Exception e) {
                throw new XJavaDocException(e);
            }
        }
        return result;
    }

    public static XTagFactory getInstance() {
        XTagFactory result = null;
        try {
            result = XTagFactory.getInstance(System.getProperty("xjavadoc.XTagFactory"));
        }
        catch (XJavaDocException e) {
            try {
                result = XTagFactory.getInstance(DEFAULT_FACTORY);
            }
            catch (XJavaDocException e2) {
                throw new RuntimeException("xjavadoc.DefaultXTagFactory does not exist (!?)");
            }
        }
        return result;
    }

    public abstract XTag createTag(String var1, String var2);

    static {
        DEFAULT_FACTORY = DEFAULT_FACTORY;
        _factories = new HashMap();
    }
}

