/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import xjavadoc.AbstractClass;
import xjavadoc.BinaryClass;
import xjavadoc.ClassIterator;
import xjavadoc.ConstructorImpl;
import xjavadoc.DefaultXTag;
import xjavadoc.MethodImpl;
import xjavadoc.PackageIterator;
import xjavadoc.ParameterImpl;
import xjavadoc.Primitive;
import xjavadoc.SimpleNode;
import xjavadoc.SourceClass;
import xjavadoc.SourceSet;
import xjavadoc.UnknownClass;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XDoc;
import xjavadoc.XJavaDocException;
import xjavadoc.XJavaDocRoot;
import xjavadoc.XMethod;
import xjavadoc.XPackage;
import xjavadoc.util.Pool;

public final class XJavaDoc
implements XJavaDocRoot {
    public static final List PRIMITIVES = Collections.unmodifiableList(Arrays.asList("void", "byte", "short", "int", "long", "char", "float", "double", "boolean"));
    public static final int NO_IMPORTED_PACKAGES = 0;
    public static final int ONE_OR_MORE_IMPORTED_PACKAGES = 1;
    private static HashMap _primitiveClasses;
    private static XJavaDoc _instance;
    private final Log _log = LogFactory.getLog(this.getClass());
    private final Map _binaryClasses = new HashMap();
    private final Map _unknownClasses = new HashMap();
    private final Map _packages = new HashMap();
    private final Set _sourceSets = new HashSet();
    private final Map _sourceSetSourceClasses = new HashMap();
    private final Map _allSourceClasses = new HashMap();
    private long _birthday;
    private List _logMessages = new LinkedList();
    private boolean _useNodeParser = false;
    private boolean _lockSourceClasses = false;
    private Set _sourceSetClassNames = new TreeSet();

    private XJavaDoc() {
        this._birthday = System.currentTimeMillis();
    }

    public static XJavaDoc getInstance() {
        return _instance;
    }

    public static void printMemoryStatus() {
        System.out.println("ParameterImpl instances:   " + ParameterImpl.instanceCount);
        System.out.println("MethodImpl instances:      " + MethodImpl.instanceCount);
        System.out.println("ConstructorImpl instances: " + ConstructorImpl.instanceCount);
        System.out.println("SimpleNode instances:      " + SimpleNode.instanceCount);
        System.out.println("SourceClass instances:     " + SourceClass.instanceCount);
        System.out.println("XDoc instances:            " + XDoc.instanceCount);
        System.out.println("DefaultXTag instances:     " + DefaultXTag.instanceCount);
        System.out.println("BinaryClass instances:     " + BinaryClass.instanceCount);
        System.out.println("UnknownClass instances:    " + UnknownClass.instanceCount);
        System.out.println("Total memory:    " + Runtime.getRuntime().totalMemory() / 0x100000L);
        System.out.println("Free memory:    " + Runtime.getRuntime().freeMemory() / 0x100000L);
    }

    static Primitive getPrimitive(String name) {
        return (Primitive)_primitiveClasses.get(name);
    }

    private static final void addPrimitive(String name) {
        _primitiveClasses.put(name, new Primitive(name));
    }

    public XClass getXClass(String qualifiedName) {
        XClass clazz = this.getXClass(qualifiedName, this._useNodeParser);
        return clazz;
    }

    public Collection getSourceClasses() {
        return this.getSourceClasses(this._useNodeParser);
    }

    public Collection getSourceClasses(boolean useNodeParser) {
        this._useNodeParser = useNodeParser;
        if (this._sourceSetSourceClasses.isEmpty()) {
            Iterator i = this._sourceSetClassNames.iterator();
            while (i.hasNext()) {
                String qualifiedName = (String)i.next();
                XClass clazz = this.getXClass(qualifiedName, useNodeParser);
            }
        }
        ArrayList new_collection = new ArrayList(this._sourceSetSourceClasses.values());
        return Collections.unmodifiableCollection(new_collection);
    }

    public Collection getSourcePackages() {
        return this.getSourcePackages(this._useNodeParser);
    }

    public Collection getSourcePackages(boolean useNodeParser) {
        TreeSet<XPackage> packages = new TreeSet<XPackage>();
        Collection classes = this.getSourceClasses(useNodeParser);
        ClassIterator i = XCollections.classIterator(classes);
        while (i.hasNext()) {
            packages.add(i.next().getContainingPackage());
        }
        return Collections.unmodifiableCollection(packages);
    }

    public void printLogMessages(PrintStream out, int level) {
        boolean printedHeader = false;
        Iterator i = this._logMessages.iterator();
        while (i.hasNext()) {
            LogMessage m = (LogMessage)i.next();
            if (m._level != level) continue;
            if (!printedHeader) {
                if (level == 1) {
                    out.println("WARNING: Some classes refer to other classes that were not found among the sources or on the classpath.");
                    out.println("         (Perhaps the referred class doesn't exist? Hasn't been generated yet?)");
                    out.println("         The referring classes do not import any fully qualified classes matching these classes.");
                    out.println("         Since at least one package is imported, it is impossible for xjavadoc to figure out");
                    out.println("         what package the referred classes belong to. The classes are:");
                } else {
                    out.println("INFO:    Some classes refer to other classes that were not found among the sources or on the classpath.");
                    out.println("         (Perhaps the referred class doesn't exist? Hasn't been generated yet?)");
                    out.println("         The referring classes do not import any fully qualified classes matching these classes.");
                    out.println("         However, since no packages are imported, xjavadoc has assumed that the referred classes");
                    out.println("         belong to the same package as the referring class. The classes are:");
                }
                printedHeader = true;
            }
            out.println(m._sourceClass.getQualifiedName() + " --> " + m._unqualifiedClassName + " qualified to " + m._unknownClass.getQualifiedName());
        }
    }

    public void addSourceSet(SourceSet sourceSet) {
        this._sourceSets.add(sourceSet);
        int j = 0;
        while (j < sourceSet.getSize()) {
            String qualifiedName = sourceSet.getQualifiedName(j);
            if (this._sourceSetClassNames.contains(qualifiedName)) {
                String msg = "The class \"" + qualifiedName + "\" occurs more than once. That's illegal.";
                System.err.println(msg);
            }
            this._sourceSetClassNames.add(qualifiedName);
            ++j;
        }
    }

    public void reset() {
        PackageIterator iterator = XCollections.packageIterator(this._packages.values());
        while (iterator.hasNext()) {
            XPackage xPackage = iterator.next();
            Collection classes = xPackage.getClasses();
            ClassIterator i = XCollections.classIterator(classes);
            while (i.hasNext()) {
                AbstractClass clazz = (AbstractClass)i.next();
                clazz.reset();
            }
        }
        this._logMessages.clear();
        this._sourceSetClassNames.clear();
        this._allSourceClasses.clear();
        this._sourceSetSourceClasses.clear();
        this._binaryClasses.clear();
        this._unknownClasses.clear();
        this._packages.clear();
        this._sourceSets.clear();
        SourceClass._qualifiedClasses.clear();
        Pool.getInstance().removeAllPools();
        this._birthday = System.currentTimeMillis();
    }

    public XClass updateMethodTag(String className, String methodNameWithSignature, String tagName, String parameterName, String parameterValue, int tagIndex) throws XJavaDocException {
        XClass clazz = this.getXClass(className, true);
        XMethod method = clazz.getMethod(methodNameWithSignature);
        XDoc doc = method.getDoc();
        doc.updateTagValue(tagName, parameterName, parameterValue, tagIndex);
        return clazz;
    }

    public XClass updateClassTag(String className, String tagName, String parameterName, String parameterValue, int tagIndex) throws XJavaDocException {
        XClass clazz = this.getXClass(className, true);
        XDoc doc = clazz.getDoc();
        doc.updateTagValue(tagName, parameterName, parameterValue, tagIndex);
        return clazz;
    }

    XClass getXClass(String qualifiedName, boolean useNodeParser) {
        if (qualifiedName.equals("")) {
            throw new IllegalStateException("Classname can't be empty String");
        }
        AbstractClass result = null;
        Primitive primitive = XJavaDoc.getPrimitive(qualifiedName);
        if (primitive != null) {
            result = primitive;
        } else {
            SourceClass sourceClass = (SourceClass)this._allSourceClasses.get(qualifiedName);
            if (sourceClass != null) {
                result = sourceClass;
            } else {
                BinaryClass binaryClass = (BinaryClass)this._binaryClasses.get(qualifiedName);
                if (binaryClass != null) {
                    result = binaryClass;
                } else {
                    UnknownClass unknownClass = (UnknownClass)this._unknownClasses.get(qualifiedName);
                    if (unknownClass != null) {
                        result = unknownClass;
                    } else if (this.sourceExists(qualifiedName)) {
                        sourceClass = this.scanAndPut(qualifiedName, useNodeParser);
                        result = sourceClass;
                    } else {
                        Class clazz = this.getClass(qualifiedName);
                        if (clazz != null) {
                            binaryClass = new BinaryClass(clazz);
                            this._binaryClasses.put(qualifiedName, binaryClass);
                            result = binaryClass;
                        } else {
                            result = new UnknownClass(qualifiedName);
                            this._unknownClasses.put(qualifiedName, result);
                        }
                    }
                }
            }
        }
        return result;
    }

    final boolean classExists(String qualifiedClassName) {
        if (this.sourceExists(qualifiedClassName)) {
            return true;
        }
        return this.getClass(qualifiedClassName) != null;
    }

    void logMessage(SourceClass clazz, UnknownClass unknownClass, String unqualifiedClassName, int level) {
        this._logMessages.add(new LogMessage(clazz, unknownClass, unqualifiedClassName, level));
    }

    XPackage addPackageMaybe(String packageName) {
        XPackage result = (XPackage)this._packages.get(packageName);
        if (result == null) {
            result = new XPackage(packageName);
            this._packages.put(packageName, result);
        }
        return result;
    }

    void addSourceClass(SourceClass sourceClass) {
        this._allSourceClasses.put(sourceClass.getQualifiedName(), sourceClass);
        if (this._sourceSetClassNames.contains(sourceClass.getQualifiedName())) {
            this._sourceSetSourceClasses.put(sourceClass.getQualifiedName(), sourceClass);
        }
    }

    private final Class getClass(String qualifiedName) {
        try {
            return Class.forName(qualifiedName, true, this.getClass().getClassLoader());
        }
        catch (Throwable e) {
            return null;
        }
    }

    private File getSourceFile(String qualifiedName) {
        File found = null;
        Iterator i = this._sourceSets.iterator();
        while (i.hasNext()) {
            SourceSet sourceSet = (SourceSet)i.next();
            File javaFile = sourceSet.getSourceFile(qualifiedName);
            if (javaFile == null) continue;
            if (found != null && !found.getAbsolutePath().equals(javaFile.getAbsolutePath())) {
                throw new IllegalStateException("Ambiguous sources for " + qualifiedName + " : " + found.getAbsolutePath() + " or " + javaFile.getAbsolutePath());
            }
            found = javaFile;
        }
        return found;
    }

    private boolean sourceExists(String qualifiedName) {
        File sourceFile = this.getSourceFile(qualifiedName);
        if (sourceFile != null && sourceFile.exists() && sourceFile.lastModified() > this._birthday) {
            return false;
        }
        return sourceFile != null;
    }

    private SourceClass scanAndPut(String qualifiedName, boolean useNodeParser) {
        File sourceFile = this.getSourceFile(qualifiedName);
        if (sourceFile == null) {
            throw new IllegalStateException("No source found for " + qualifiedName);
        }
        SourceClass sourceClass = new SourceClass(qualifiedName, sourceFile);
        this.addSourceClass(sourceClass);
        sourceClass.parse(useNodeParser);
        return sourceClass;
    }

    static {
        NO_IMPORTED_PACKAGES = 0;
        ONE_OR_MORE_IMPORTED_PACKAGES = 1;
        _primitiveClasses = new HashMap();
        _instance = new XJavaDoc();
        int i = 0;
        while (i < PRIMITIVES.size()) {
            XJavaDoc.addPrimitive((String)PRIMITIVES.get(i));
            ++i;
        }
    }

    class LogMessage {
        public final SourceClass _sourceClass;
        public final UnknownClass _unknownClass;
        public final String _unqualifiedClassName;
        public final int _level;

        LogMessage(SourceClass sourceClass, UnknownClass unknownClass, String unqualifiedClassName, int level) {
            this._sourceClass = sourceClass;
            this._unknownClass = unknownClass;
            this._unqualifiedClassName = unqualifiedClassName;
            this._level = level;
        }
    }
}

