/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import xjavadoc.JavaParser;
import xjavadoc.Node;
import xjavadoc.NodeParserTreeConstants;
import xjavadoc.Token;

final class SimpleNode
implements Node {
    public static int instanceCount = 0;
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    protected Token first;
    protected Token last;

    public SimpleNode(int i) {
        this.id = i;
        ++instanceCount;
    }

    public SimpleNode(JavaParser p, int i) {
        this(i);
        this.parser = p;
    }

    public Token getFirstToken() {
        return this.first;
    }

    public Token getLastToken() {
        return this.last;
    }

    public void jjtOpen() {
        this.first = this.parser.getToken(1);
    }

    public void jjtClose() {
        this.last = this.parser.getToken(0);
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return NodeParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(prefix + ' ');
                }
                ++i;
            }
        }
    }
}

