/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.test.BaseTestCase;
import org.apache.velocity.test.TemplateTestBase;

public class InlineScopeVMTestCase
extends BaseTestCase
implements TemplateTestBase {
    private static final String TEST_CASE_NAME = "InlineScopeVMTestCase";

    public static Test suite() {
        return new InlineScopeVMTestCase();
    }

    public void runTest() {
        try {
            BaseTestCase.assureResultsDirectoryExists("../test/templates/results");
            Template template2 = RuntimeSingleton.getTemplate(BaseTestCase.getFileName(null, "vm_test2", "vm"));
            Template template1 = RuntimeSingleton.getTemplate(BaseTestCase.getFileName(null, "vm_test1", "vm"));
            FileOutputStream fos1 = new FileOutputStream(BaseTestCase.getFileName("../test/templates/results", "vm_test1", "res"));
            FileOutputStream fos2 = new FileOutputStream(BaseTestCase.getFileName("../test/templates/results", "vm_test2", "res"));
            BufferedWriter writer1 = new BufferedWriter(new OutputStreamWriter(fos1));
            BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(fos2));
            VelocityContext context = new VelocityContext();
            template1.merge(context, writer1);
            ((Writer)writer1).flush();
            ((Writer)writer1).close();
            template2.merge(context, writer2);
            ((Writer)writer2).flush();
            ((Writer)writer2).close();
            if (!this.isMatch("../test/templates/results", "../test/templates/compare", "vm_test1", "res", "cmp") || !this.isMatch("../test/templates/results", "../test/templates/compare", "vm_test2", "res", "cmp")) {
                Assert.fail((String)"Output incorrect.");
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    InlineScopeVMTestCase() {
        super(TEST_CASE_NAME);
        try {
            Velocity.setProperty("velocimacro.permissions.allow.inline.to.replace.global", "true");
            Velocity.setProperty("velocimacro.permissions.allow.inline.local.scope", "true");
            Velocity.setProperty("file.resource.loader.path", "../test/templates");
            Velocity.init();
        }
        catch (Exception e) {
            System.err.println("Cannot setup InlineScopeVMTestCase");
            System.exit(1);
        }
    }
}

