/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;
import org.apache.log.output.AbstractTarget;

public abstract class AbstractOutputTarget
extends AbstractTarget {
    protected Formatter m_formatter;

    public synchronized Formatter getFormatter() {
        return this.m_formatter;
    }

    public synchronized void setFormatter(Formatter formatter) {
        this.writeTail();
        this.m_formatter = formatter;
        this.writeHead();
    }

    protected void write(String data) {
        this.output(data);
    }

    protected void output(String data) {
    }

    protected void doProcessEvent(LogEvent event) {
        String data = this.format(event);
        this.write(data);
    }

    protected synchronized void open() {
        if (!this.isOpen()) {
            super.open();
            this.writeHead();
        }
    }

    public synchronized void close() {
        if (this.isOpen()) {
            this.writeTail();
            super.close();
        }
    }

    private String format(LogEvent event) {
        if (this.m_formatter != null) {
            return this.m_formatter.format(event);
        }
        return event.toString();
    }

    private void writeHead() {
        if (!this.isOpen()) {
            return;
        }
        String head = this.getHead();
        if (head != null) {
            this.write(head);
        }
    }

    private void writeTail() {
        if (!this.isOpen()) {
            return;
        }
        String tail = this.getTail();
        if (tail != null) {
            this.write(tail);
        }
    }

    private String getHead() {
        return null;
    }

    private String getTail() {
        return null;
    }

    public AbstractOutputTarget() {
    }

    public AbstractOutputTarget(Formatter formatter) {
        this.m_formatter = formatter;
    }
}

