/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.util.Stack;

public class ContextStack {
    private static final ThreadLocal c_context = new ThreadLocal();
    private Stack m_stack = new Stack();

    public static final ContextStack getCurrentContext() {
        return ContextStack.getCurrentContext(true);
    }

    static final ContextStack getCurrentContext(boolean autocreate) {
        ContextStack context = (ContextStack)c_context.get();
        if (context == null && autocreate) {
            context = new ContextStack();
            context.push(Thread.currentThread().getName());
            c_context.set(context);
        }
        return context;
    }

    public void clear() {
        this.m_stack.setSize(0);
    }

    public Object get(int index) {
        return this.m_stack.elementAt(index);
    }

    public Object pop() {
        return this.m_stack.pop();
    }

    public void push(Object context) {
        this.m_stack.push(context);
    }

    public void set(ContextStack stack) {
        this.clear();
        int size = stack.m_stack.size();
        int i = 0;
        while (i < size) {
            this.m_stack.push(stack.m_stack.elementAt(i));
            ++i;
        }
    }

    public int getSize() {
        return this.m_stack.size();
    }

    public String toString() {
        return this.toString(this.getSize());
    }

    public String toString(int count) {
        int start;
        StringBuffer sb = new StringBuffer();
        int end = this.getSize() - 1;
        int i = start = Math.max(end - count + 1, 0);
        while (i < end) {
            sb.append(this.fix(this.get(i).toString()));
            sb.append('.');
            ++i;
        }
        sb.append(this.fix(this.get(end).toString()));
        return sb.toString();
    }

    private String fix(String context) {
        return context.replace('.', '_');
    }
}

