/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.ant;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.tools.infobuilder.InfoBuilder;
import org.apache.avalon.phoenix.framework.tools.verifier.InfoVerifier;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ComponentVerifierTask
extends Task {
    private Path m_classpath;
    private String m_classname;

    public void setClassname(String classname) {
        this.m_classname = classname;
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.getProject());
        }
        return this.m_classpath.createPath();
    }

    public void execute() throws BuildException {
        if (null == this.m_classname) {
            String message = "User did not specify classname";
            throw new BuildException("User did not specify classname");
        }
        if (null == this.m_classpath) {
            String message = "User did not specify classpath";
            throw new BuildException("User did not specify classpath");
        }
        AntClassLoader classLoader = new AntClassLoader(this.getProject(), this.m_classpath);
        InfoBuilder builder = new InfoBuilder();
        builder.enableLogging((Logger)new ConsoleLogger(1));
        InfoVerifier verifier = new InfoVerifier();
        verifier.enableLogging((Logger)new ConsoleLogger(1));
        try {
            Class implementation = classLoader.loadClass(this.m_classname);
            ComponentInfo componentInfo = builder.buildComponentInfo(implementation);
            verifier.verifyType("test", this.m_classname, componentInfo, implementation);
        }
        catch (Exception e) {
            String message = "Failed to validate " + this.m_classname + " due to " + e;
            throw new BuildException(message, (Throwable)e);
        }
    }
}

