/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.info;

import org.apache.avalon.phoenix.framework.info.Attribute;
import org.apache.avalon.phoenix.framework.info.FeatureDescriptor;

public final class DependencyDescriptor
extends FeatureDescriptor {
    public static final DependencyDescriptor[] EMPTY_SET = new DependencyDescriptor[0];
    public static final String ARRAY_POSTFIX = "[]";
    public static final String MAP_POSTFIX = "{}";
    private final String m_key;
    private final String m_type;
    private final boolean m_optional;

    public DependencyDescriptor(String key, String type, boolean optional, Attribute[] attributes) {
        super(attributes);
        if (null == key) {
            throw new NullPointerException("key");
        }
        if (null == type) {
            throw new NullPointerException("type");
        }
        this.m_key = key;
        this.m_type = type;
        this.m_optional = optional;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public boolean isArray() {
        return this.getType().endsWith(ARRAY_POSTFIX);
    }

    public boolean isMap() {
        return this.getType().endsWith(MAP_POSTFIX);
    }

    public String getComponentType() {
        String fullname = this.getType();
        if (this.isArray()) {
            int end = fullname.length() - ARRAY_POSTFIX.length();
            return fullname.substring(0, end);
        }
        if (this.isMap()) {
            int end = fullname.length() - MAP_POSTFIX.length();
            return fullname.substring(0, end);
        }
        return fullname;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_key);
        sb.append('/');
        sb.append(this.m_type);
        if (this.m_optional) {
            sb.append("(Optional)");
        }
        sb.append(this.attributesToString());
        return sb.toString();
    }
}

