/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.services.scheduler;

import org.apache.avalon.cornerstone.services.scheduler.CronTimeTrigger;
import org.apache.avalon.cornerstone.services.scheduler.PeriodicTimeTrigger;
import org.apache.avalon.cornerstone.services.scheduler.TimeTrigger;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class TimeTriggerFactory {
    /*
     * WARNING - void declaration
     */
    public TimeTrigger createTimeTrigger(Configuration conf) throws ConfigurationException {
        void var3_7;
        TimeTrigger trigger;
        String type = conf.getAttribute("type");
        if ("periodic".equals(type)) {
            int offset = conf.getChild("offset", true).getValueAsInteger(0);
            int period = conf.getChild("period", true).getValueAsInteger(-1);
            trigger = new PeriodicTimeTrigger(offset, period);
        } else if ("cron".equals(type)) {
            int minute = conf.getChild("minute").getValueAsInteger(-1);
            int hour = conf.getChild("hour").getValueAsInteger(-1);
            int day = conf.getChild("day").getValueAsInteger(-1);
            int month = conf.getChild("month").getValueAsInteger(-1);
            int year = conf.getChild("year").getValueAsInteger(-1);
            boolean dayOfWeek = conf.getChild("day").getAttributeAsBoolean("week", false);
            trigger = new CronTimeTrigger(minute, hour, day, month, year, dayOfWeek);
        } else {
            throw new ConfigurationException("Unknown trigger type");
        }
        return var3_7;
    }
}

