/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaSource
implements Serializable,
JavaClassParent {
    private static final Set PRIMITIVE_TYPES = new HashSet();
    private File file;
    private String packge;
    private List imports = new LinkedList();
    private String[] importsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private ClassLibrary classLibrary;
    private Map typeCache = new HashMap();

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String getPackage() {
        return this.packge;
    }

    public void setPackage(String packge) {
        this.packge = packge;
    }

    public void addImport(String imp) {
        this.imports.add(imp);
        this.importsArray = null;
    }

    public String[] getImports() {
        if (this.importsArray == null) {
            this.importsArray = new String[this.imports.size()];
            this.imports.toArray(this.importsArray);
        }
        return this.importsArray;
    }

    public void addClass(JavaClass imp) {
        this.classes.add(imp);
        imp.setParent(this);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public String toString() {
        IndentBuffer result = new IndentBuffer();
        if (this.packge != null) {
            result.write("package ");
            result.write(this.packge);
            result.write(';');
            result.newline();
            result.newline();
        }
        String[] imports = this.getImports();
        int i = 0;
        while (imports != null && i < imports.length) {
            result.write("import ");
            result.write(imports[i]);
            result.write(';');
            result.newline();
            ++i;
        }
        if (imports != null && imports.length > 0) {
            result.newline();
        }
        JavaClass[] classes = this.getClasses();
        int i2 = 0;
        while (i2 < classes.length) {
            if (i2 > 0) {
                result.newline();
            }
            classes[i2].write(result);
            ++i2;
        }
        return result.toString();
    }

    public String resolveType(String typeName) {
        String resolved = (String)this.typeCache.get(typeName);
        if (resolved != null) {
            return resolved;
        }
        resolved = this.resolveTypeInternal(typeName);
        if (resolved != null) {
            this.typeCache.put(typeName, resolved);
        }
        return resolved;
    }

    private String resolveTypeInternal(String typeName) {
        if (typeName.indexOf(46) != -1) {
            return typeName;
        }
        if (PRIMITIVE_TYPES.contains(typeName)) {
            return typeName;
        }
        String[] imports = this.getImports();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].endsWith("." + typeName)) {
                return imports[i];
            }
            ++i;
        }
        if (this.getClassLibrary() == null) {
            return null;
        }
        String potentialName = this.packge + "." + typeName;
        if (this.getClassLibrary().contains(potentialName)) {
            return potentialName;
        }
        int i2 = 0;
        while (i2 < imports.length) {
            if (imports[i2].endsWith(".*")) {
                potentialName = imports[i2].substring(0, imports[i2].length() - 1) + typeName;
                if (this.getClassLibrary().contains(potentialName)) {
                    return potentialName;
                }
            }
            ++i2;
        }
        potentialName = "java.lang." + typeName;
        if (this.getClassLibrary().contains(potentialName)) {
            return potentialName;
        }
        return null;
    }

    public String asClassNamespace() {
        return this.getPackage();
    }

    public JavaSource getParentSource() {
        return this;
    }

    static {
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("char");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("void");
    }
}

