/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;

public class JavaMethod
extends AbstractJavaEntity {
    protected Type returns;
    private JavaParameter[] parameters;
    private Type[] exceptions;
    private boolean constructor;
    private JavaClass parentClass;

    public Type getReturns() {
        return this.returns;
    }

    public JavaParameter[] getParameters() {
        return this.parameters == null ? new JavaParameter[]{} : this.parameters;
    }

    public Type[] getExceptions() {
        return this.exceptions;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    protected void writeBody(IndentBuffer result) {
        int i;
        this.writeAccessibilityModifier(result);
        this.writeNonAccessibilityModifiers(result);
        if (!this.constructor) {
            result.write(this.returns.getValue());
            i = 0;
            while (i < this.returns.getDimensions()) {
                result.write("[]");
                ++i;
            }
            result.write(' ');
        }
        result.write(this.name);
        result.write('(');
        i = 0;
        while (this.parameters != null && i < this.parameters.length) {
            JavaParameter parameter = this.parameters[i];
            if (i > 0) {
                result.write(", ");
            }
            result.write(parameter.getType().getValue());
            int j = 0;
            while (j < parameter.getType().getDimensions()) {
                result.write("[]");
                ++j;
            }
            result.write(' ');
            result.write(parameter.getName());
            ++i;
        }
        result.write(')');
        if (this.exceptions != null && this.exceptions.length > 0) {
            result.write(" throws ");
            int i2 = 0;
            while (i2 < this.exceptions.length) {
                if (i2 > 0) {
                    result.write(", ");
                }
                result.write(this.exceptions[i2].getValue());
                ++i2;
            }
        }
        result.write(';');
        result.newline();
    }

    public void setReturns(Type returns) {
        this.returns = returns;
    }

    public void setParameters(JavaParameter[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            parameters[i].setParentMethod(this);
            ++i;
        }
        this.parameters = parameters;
    }

    public void setExceptions(Type[] exceptions) {
        this.exceptions = exceptions;
    }

    public void setConstructor(boolean constructor) {
        this.constructor = constructor;
    }

    public boolean equals(Object obj) {
        JavaMethod m = (JavaMethod)obj;
        if (!m.getName().equals(this.getName())) {
            return false;
        }
        if (!m.getReturns().equals(this.getReturns())) {
            return false;
        }
        JavaParameter[] myParams = this.getParameters();
        JavaParameter[] otherParams = m.getParameters();
        if (otherParams.length != myParams.length) {
            return false;
        }
        int i = 0;
        while (i < myParams.length) {
            if (!otherParams[i].equals(myParams[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.name.hashCode() * this.returns.hashCode() * this.getParameters().length;
    }

    public JavaClass getParentClass() {
        return this.parentClass;
    }

    public void setParentClass(JavaClass parentClass) {
        this.parentClass = parentClass;
    }
}

