/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;

public class Util {
    private static final FileFilter _javaFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().endsWith(".java");
        }
    };
    private static final FileFilter _dirFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory();
        }
    };

    public static String[] getJavaFiles(File root) {
        LinkedList javaFileNames = new LinkedList();
        Util.descend(root, "", javaFileNames);
        return javaFileNames.toArray(new String[javaFileNames.size()]);
    }

    public static final StringBuffer appendDimensionAsString(int n, StringBuffer sb) {
        int i = 0;
        while (i < n) {
            sb.append("[]");
            ++i;
        }
        return sb;
    }

    public static final String toString(Object[] array, String delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            sb.append(array[i].toString());
            if (i < array.length - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String classNameFromQualifiedClassName(String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("qualifiedName can't be null!");
        }
        int dot_index = qualifiedName.lastIndexOf(46);
        if (dot_index != -1) {
            return qualifiedName.substring(dot_index + 1);
        }
        return qualifiedName;
    }

    private static void descend(File root, String dirName, LinkedList javaFileNames) {
        File dir = new File(root, dirName);
        File[] javaFiles = dir.listFiles(_javaFilter);
        int i = 0;
        while (i < javaFiles.length) {
            StringBuffer javaFileName = new StringBuffer();
            if (dirName.length() != 0) {
                javaFileName.append(dirName).append(File.separator);
            }
            javaFileName.append(javaFiles[i].getName());
            javaFileNames.add(javaFileName.toString());
            ++i;
        }
        File[] subDirs = dir.listFiles(_dirFilter);
        int i2 = 0;
        while (i2 < subDirs.length) {
            StringBuffer subDirName = new StringBuffer(dirName);
            if (dirName.length() != 0) {
                subDirName.append(File.separator);
            }
            subDirName.append(subDirs[i2].getName());
            Util.descend(root, subDirName.toString(), javaFileNames);
            ++i2;
        }
    }
}

