/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import xjavadoc.AbstractClass;
import xjavadoc.JavaParser;
import xjavadoc.NodeParser;
import xjavadoc.NodePrinter;
import xjavadoc.ParseException;
import xjavadoc.Primitive;
import xjavadoc.SimpleNode;
import xjavadoc.SimpleParser;
import xjavadoc.TokenMgrError;
import xjavadoc.UnknownClass;
import xjavadoc.XClass;
import xjavadoc.XJavaDoc;
import xjavadoc.XPackage;

final class SourceClass
extends AbstractClass {
    public static int instanceCount = 0;
    public static Map _qualifiedClasses = new HashMap();
    private static final Log _log = LogFactory.getLog((Class)(class$xjavadoc$SourceClass == null ? (class$xjavadoc$SourceClass = SourceClass.class$("xjavadoc.SourceClass")) : class$xjavadoc$SourceClass));
    private SimpleNode _compilationUnit;
    private Reader _in = null;
    private File _sourceFile;
    private JavaParser _parser;
    static /* synthetic */ Class class$xjavadoc$SourceClass;

    public SourceClass(SourceClass containingClass) {
        super(containingClass);
    }

    public SourceClass(String qualifiedName, File sourceFile) {
        super(null);
        this.setQualifiedName(qualifiedName);
        if (sourceFile == null) {
            throw new IllegalArgumentException("sourceFile can't be null for outer classes!");
        }
        this._sourceFile = sourceFile;
        try {
            this._in = new FileReader(sourceFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Couldn't find source for " + qualifiedName + " at " + sourceFile.getAbsolutePath());
        }
        String packageName = AbstractClass.getPackageNameFor(qualifiedName);
        XJavaDoc.getInstance().addPackageMaybe(packageName).addClass(this);
        ++instanceCount;
    }

    public static String getFileName(String qualifiedName) {
        return qualifiedName.replace('.', File.separatorChar) + ".java";
    }

    public String getNextAnonymousClassName() {
        return String.valueOf(this.getInnerClasses().size() + 1);
    }

    public boolean isOuterClass() {
        return this._in != null;
    }

    public boolean isWriteable() {
        return this._compilationUnit != null;
    }

    public void setCompilationUnit(SimpleNode compilationUnit) {
        this._compilationUnit = compilationUnit;
    }

    public long lastModified() {
        if (this.isOuterClass()) {
            return this._sourceFile.lastModified();
        }
        return this.getContainingClass().lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(boolean useNodeParser) {
        block5: {
            this._parser = useNodeParser ? new NodeParser(this._in) : new SimpleParser(this._in);
            try {
                try {
                    this._parser.CompilationUnit(this);
                }
                catch (ParseException e) {
                    String cls = this.getSourceFile() != null ? this.getSourceFile().getAbsolutePath() : this.getQualifiedName();
                    System.err.println("Error parsing " + cls + ':' + e.getMessage());
                    Object var6_3 = null;
                    this._parser = null;
                    break block5;
                }
                catch (TokenMgrError e) {
                    String cls = this.getSourceFile() != null ? this.getSourceFile().getAbsolutePath() : this.getQualifiedName();
                    System.err.println("Error parsing " + cls + ':' + e.getMessage());
                    Object var6_4 = null;
                    this._parser = null;
                }
                Object var6_2 = null;
                this._parser = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this._parser = null;
                throw throwable;
            }
        }
    }

    public void print(PrintStream out) {
        this.updateDoc();
        if (!this.isWriteable()) {
            _log.error((Object)("attempt to save not writable class: " + this.toString()));
            throw new UnsupportedOperationException("Can't save classes that are parsed with simpleparser");
        }
        NodePrinter.print(this._compilationUnit, out);
    }

    public String save(File rootDir) throws IOException {
        if (this.getContainingClass() != null) {
            throw new UnsupportedOperationException("Can't save inner classes");
        }
        if (rootDir != null) {
            String fileName = SourceClass.getFileName(this.getQualifiedName());
            File javaFile = new File(rootDir, fileName);
            javaFile.getParentFile().mkdirs();
            this.print(new PrintStream(new FileOutputStream(javaFile)));
            return fileName;
        }
        this.print(new PrintStream(new FileOutputStream(this._sourceFile)));
        return this._sourceFile.getPath();
    }

    public XClass qualify(String unqualifiedClassName) {
        XClass result = null;
        result = (XClass)_qualifiedClasses.get(unqualifiedClassName);
        if (result == null) {
            if (this.getContainingClass() == null) {
                if (unqualifiedClassName.indexOf(46) != -1) {
                    result = XJavaDoc.getInstance().getXClass(unqualifiedClassName);
                } else {
                    Primitive primitive = XJavaDoc.getPrimitive(unqualifiedClassName);
                    if (primitive != null) {
                        result = primitive;
                    } else {
                        String qualifiedName = this.unqualifiedNameInTheSameClassAsAnInnerClass(unqualifiedClassName);
                        if (qualifiedName != null) {
                            result = XJavaDoc.getInstance().getXClass(qualifiedName);
                        } else {
                            qualifiedName = this.unqualifiedNameInInnerClasses(unqualifiedClassName);
                            if (qualifiedName != null) {
                                result = XJavaDoc.getInstance().getXClass(qualifiedName);
                            } else {
                                qualifiedName = this.unqualifiedNameInJavaDotLang(unqualifiedClassName);
                                if (qualifiedName != null) {
                                    result = XJavaDoc.getInstance().getXClass(qualifiedName);
                                } else {
                                    qualifiedName = this.unqualifiedNameInImportedClasses(unqualifiedClassName);
                                    if (qualifiedName != null) {
                                        result = XJavaDoc.getInstance().getXClass(qualifiedName);
                                    } else {
                                        qualifiedName = this.unqualifiedNameInImportedPackages(unqualifiedClassName);
                                        if (qualifiedName != null) {
                                            result = XJavaDoc.getInstance().getXClass(qualifiedName);
                                        } else {
                                            qualifiedName = this.unqualifiedNameInTheSamePackage(unqualifiedClassName);
                                            if (qualifiedName != null) {
                                                result = XJavaDoc.getInstance().getXClass(qualifiedName);
                                            } else {
                                                if (this.getContainingPackage().getName().equals("")) {
                                                    String unknownClassName = unqualifiedClassName;
                                                } else {
                                                    String unknownClassName = this.getContainingPackage().getName() + "." + unqualifiedClassName;
                                                }
                                                UnknownClass unknownClass = new UnknownClass(unqualifiedClassName);
                                                if (!this.hasImportedPackages()) {
                                                    XJavaDoc.getInstance().logMessage(this, unknownClass, unqualifiedClassName, 0);
                                                } else {
                                                    XJavaDoc.getInstance().logMessage(this, unknownClass, unqualifiedClassName, 1);
                                                }
                                                result = unknownClass;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                result = this.getContainingAbstractClass().qualify(unqualifiedClassName);
            }
            _qualifiedClasses.put(unqualifiedClassName, result);
        }
        return result;
    }

    public void reset() {
        super.reset();
        this._compilationUnit = null;
        this._in = null;
        this._sourceFile = null;
    }

    File getSourceFile() {
        return this._sourceFile;
    }

    private final String unqualifiedNameInImportedClasses(String unqualifiedClassName) {
        if (!this.hasImportedClasses()) {
            return null;
        }
        String suffix = "." + unqualifiedClassName;
        String candidate = null;
        Iterator i = this.getImportedClasses().iterator();
        while (i.hasNext()) {
            String qualifiedClassName = ((XClass)i.next()).getQualifiedName();
            if (!qualifiedClassName.endsWith(suffix)) continue;
            if (candidate != null && !candidate.equals(qualifiedClassName)) {
                throw new IllegalStateException("In class " + this.getQualifiedName() + ": Ambiguous class:" + unqualifiedClassName + ". Is it " + candidate + " or " + qualifiedClassName + "?");
            }
            candidate = qualifiedClassName;
        }
        return candidate;
    }

    private final String unqualifiedNameInInnerClasses(String unqualifiedClassName) {
        if (!this.hasInnerClasses()) {
            return null;
        }
        String innerClassName = this.getQualifiedName() + '.' + unqualifiedClassName;
        String candidate = null;
        Iterator i = this.getInnerClasses().iterator();
        while (i.hasNext()) {
            XClass innerClass = (XClass)i.next();
            String qualifiedClassName = innerClass.getQualifiedName();
            if (!innerClassName.equals(qualifiedClassName)) continue;
            candidate = qualifiedClassName;
            break;
        }
        return candidate;
    }

    private final String unqualifiedNameInImportedPackages(String unqualifiedClassName) {
        if (!this.hasImportedPackages()) {
            return null;
        }
        String suffix = "." + unqualifiedClassName;
        String candidate = null;
        Iterator i = this.getImportedPackages().iterator();
        while (i.hasNext()) {
            String importedPackageName = ((XPackage)i.next()).getName();
            String qualifiedClassName = importedPackageName + suffix;
            if (!XJavaDoc.getInstance().classExists(qualifiedClassName)) continue;
            if (candidate != null && !candidate.equals(qualifiedClassName)) {
                throw new IllegalStateException("In class " + this.getQualifiedName() + ": Ambiguous class:" + unqualifiedClassName + ". Is it " + candidate + " or " + qualifiedClassName + "?");
            }
            candidate = qualifiedClassName;
        }
        return candidate;
    }

    private final String unqualifiedNameInJavaDotLang(String unqualifiedClassName) {
        String qualifiedClassName = "java.lang." + unqualifiedClassName;
        if (XJavaDoc.getInstance().classExists(qualifiedClassName)) {
            return qualifiedClassName;
        }
        return null;
    }

    private final String unqualifiedNameInTheSamePackage(String unqualifiedClassName) {
        String qualifiedClassName = this.getContainingPackage().getName().equals("") ? unqualifiedClassName : this.getContainingPackage().getName() + '.' + unqualifiedClassName;
        if (XJavaDoc.getInstance().classExists(qualifiedClassName)) {
            return qualifiedClassName;
        }
        return null;
    }

    private final String unqualifiedNameInTheSameClassAsAnInnerClass(String unqualifiedClassName) {
        String qualifiedClassName = this.getQualifiedName() + '.' + unqualifiedClassName;
        if (XJavaDoc.getInstance().classExists(qualifiedClassName)) {
            return qualifiedClassName;
        }
        qualifiedClassName = this.getContainingPackage().getName().equals("") ? unqualifiedClassName : this.getContainingPackage().getName() + '.' + unqualifiedClassName;
        if (XJavaDoc.getInstance().classExists(qualifiedClassName)) {
            return qualifiedClassName;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

