/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.threads;

import java.util.Map;
import org.apache.avalon.cornerstone.blocks.threads.AbstractThreadManager;
import org.apache.avalon.excalibur.thread.impl.ResourceLimitingThreadPool;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class ResourceLimitingThreadManager
extends AbstractThreadManager {
    protected void configureThreadPool(Map threadPools, Configuration configuration) throws ConfigurationException {
        String name = configuration.getChild("name").getValue();
        boolean isDaemon = configuration.getChild("is-daemon").getValueAsBoolean(false);
        int max = configuration.getChild("max-threads").getValueAsInteger(10);
        boolean maxStrict = configuration.getChild("max-strict").getValueAsBoolean(true);
        boolean blocking = configuration.getChild("blocking").getValueAsBoolean(true);
        long blockTimeout = configuration.getChild("block-timeout").getValueAsLong(0L);
        long trimInterval = configuration.getChild("trim-interval").getValueAsLong(10000L);
        try {
            ResourceLimitingThreadPool threadPool = new ResourceLimitingThreadPool(name, max, maxStrict, blocking, blockTimeout, trimInterval);
            threadPool.setDaemon(isDaemon);
            threadPool.enableLogging(this.getLogger());
            threadPools.put(name, threadPool);
        }
        catch (Exception e) {
            String message = "Error creating ThreadPool named " + name;
            throw new ConfigurationException(message, (Throwable)e);
        }
    }
}

