/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.threads;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.excalibur.thread.ThreadPool;

public abstract class AbstractThreadManager
extends AbstractLogEnabled
implements ThreadManager,
Configurable,
Disposable {
    private HashMap m_threadPools = new HashMap();

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] groups = configuration.getChildren("thread-group");
        for (int i = 0; i < groups.length; ++i) {
            this.configureThreadPool(this.m_threadPools, groups[i]);
        }
    }

    public void dispose() {
        Iterator pools = this.m_threadPools.values().iterator();
        while (pools.hasNext()) {
            ContainerUtil.dispose(pools.next());
        }
    }

    protected abstract void configureThreadPool(Map var1, Configuration var2) throws ConfigurationException;

    public ThreadPool getThreadPool(String name) throws IllegalArgumentException {
        ThreadPool threadPool = (ThreadPool)this.m_threadPools.get(name);
        if (null == threadPool) {
            String message = "Unable to locate ThreadPool named " + name;
            throw new IllegalArgumentException(message);
        }
        return threadPool;
    }

    public ThreadPool getDefaultThreadPool() {
        return this.getThreadPool("default");
    }
}

