/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.sockets;

import java.util.HashMap;
import org.apache.avalon.cornerstone.services.sockets.ServerSocketFactory;
import org.apache.avalon.cornerstone.services.sockets.SocketFactory;
import org.apache.avalon.cornerstone.services.sockets.SocketManager;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class DefaultSocketManager
extends AbstractLogEnabled
implements SocketManager,
Contextualizable,
Configurable,
Initializable {
    protected final HashMap m_serverSockets = new HashMap();
    protected final HashMap m_sockets = new HashMap();
    protected Context m_context;
    protected Configuration m_configuration;

    public void contextualize(Context context) {
        this.m_context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
    }

    public void initialize() throws Exception {
        Configuration[] serverSockets = this.m_configuration.getChild("server-sockets").getChildren("factory");
        for (int i = 0; i < serverSockets.length; ++i) {
            Configuration element = serverSockets[i];
            String name = element.getAttribute("name");
            String className = element.getAttribute("class");
            this.setupServerSocketFactory(name, className, element);
        }
        Configuration[] clientSockets = this.m_configuration.getChild("client-sockets").getChildren("factory");
        for (int i = 0; i < clientSockets.length; ++i) {
            Configuration element = clientSockets[i];
            String name = element.getAttribute("name");
            String className = element.getAttribute("class");
            this.setupClientSocketFactory(name, className, element);
        }
    }

    protected void setupServerSocketFactory(String name, String className, Configuration configuration) throws Exception {
        Object object = this.createFactory(name, className, configuration);
        if (!(object instanceof ServerSocketFactory)) {
            throw new Exception("Error creating factory " + name + " with class " + className + " as " + "it does not implement the correct " + "interface (ServerSocketFactory)");
        }
        this.m_serverSockets.put(name, object);
    }

    protected void setupClientSocketFactory(String name, String className, Configuration configuration) throws Exception {
        Object object = this.createFactory(name, className, configuration);
        if (!(object instanceof SocketFactory)) {
            throw new Exception("Error creating factory " + name + " with class " + className + " as " + "it does not implement the correct " + "interface (SocketFactory)");
        }
        this.m_sockets.put(name, object);
    }

    protected Object createFactory(String name, String className, Configuration configuration) throws Exception {
        Object factory = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            factory = classLoader.loadClass(className).newInstance();
        }
        catch (Throwable e) {
            String error = "Error creating factory with class " + className;
            this.getLogger().error("## CLASSLOADER: " + Thread.currentThread().getContextClassLoader());
            throw new CascadingException(error, e);
        }
        ContainerUtil.enableLogging(factory, (Logger)this.getLogger());
        ContainerUtil.contextualize(factory, (Context)this.m_context);
        ContainerUtil.configure(factory, (Configuration)configuration);
        ContainerUtil.initialize(factory);
        return factory;
    }

    public ServerSocketFactory getServerSocketFactory(String name) throws Exception {
        ServerSocketFactory factory = (ServerSocketFactory)this.m_serverSockets.get(name);
        if (null != factory) {
            return factory;
        }
        throw new Exception("Unable to locate server socket factory named " + name);
    }

    public SocketFactory getSocketFactory(String name) throws Exception {
        SocketFactory factory = (SocketFactory)this.m_sockets.get(name);
        if (null != factory) {
            return factory;
        }
        throw new Exception("Unable to locate client socket factory named " + name);
    }
}

