/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tagshandler;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.TypeTagsHandler;
import xdoclet.util.DocletUtil;
import xdoclet.util.LogUtil;
import xjavadoc.ClassIterator;
import xjavadoc.ConstructorIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XConstructor;
import xjavadoc.XMember;

public class ConstructorTagsHandler
extends AbstractProgramElementTagsHandler {
    private static /* synthetic */ Class class$Lxdoclet$tagshandler$ConstructorTagsHandler;

    private static final boolean hasConstructor(XClass clazz, String constructorName, String[] parameters, boolean setCurrentConstructor) throws XDocletException {
        return AbstractProgramElementTagsHandler.hasExecutableMember(clazz, constructorName, parameters, setCurrentConstructor, 3);
    }

    public void setCurrentConstructor(String template, Properties attributes) throws XDocletException {
        String constructorName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
        }
        XConstructor oldConstructor = XDocletTagSupport.getCurrentConstructor();
        if (ConstructorTagsHandler.hasConstructor(XDocletTagSupport.getCurrentClass(), constructorName, parameters, true)) {
            this.generate(template);
        }
        XDocletTagSupport.setCurrentConstructor(oldConstructor);
    }

    public String constructorComment(Properties attributes) throws XDocletException {
        return this.memberComment(attributes, 3);
    }

    public String exceptionList(Properties attributes) throws XDocletException {
        return this.exceptionList(attributes, 3);
    }

    public void forAllClassConstructors(String template, Properties attributes) throws XDocletException {
        String typeName = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        Collection classes = AbstractProgramElementTagsHandler.getAllClasses();
        TreeSet constructors = new TreeSet();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass clazz = i.next();
            if (typeName != null && !TypeTagsHandler.isOfType(clazz, typeName, extent)) continue;
            Collection classConstructors = clazz.getConstructors();
            constructors.addAll(classConstructors);
        }
        ConstructorIterator constructorIterator = XCollections.constructorIterator(constructors);
        while (constructorIterator.hasNext()) {
            XConstructor current = constructorIterator.next();
            XDocletTagSupport.setCurrentClass(current.getContainingClass());
            XDocletTagSupport.setCurrentConstructor(current);
            this.generate(template);
        }
    }

    public void forAllConstructors(String template, Properties attributes) throws XDocletException {
        this.forAllMembers(template, attributes, 3);
    }

    public void ifDoesntHaveConstructorTag(String template, Properties attributes) throws XDocletException {
        if (!XDocletTagSupport.hasTag(attributes, 3)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void ifHasConstructorTag(String template, Properties attributes) throws XDocletException {
        if (XDocletTagSupport.hasTag(attributes, 3)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }

    public void executeAndRestoreConstructor(String template, Properties attributes) throws XDocletException {
        XConstructor constructor = XDocletTagSupport.getCurrentConstructor();
        this.generate(template);
        XDocletTagSupport.setCurrentConstructor(constructor);
    }

    public void ifConstructorTagValueEquals(String template, Properties attributes) throws XDocletException {
        if (XDocletTagSupport.isTagValueEqual(attributes, 3)) {
            this.generate(template);
        }
    }

    public void ifConstructorTagValueNotEquals(String template, Properties attributes) throws XDocletException {
        if (!XDocletTagSupport.isTagValueEqual(attributes, 3)) {
            this.generate(template);
        }
    }

    public String constructorTagValue(Properties attributes) throws XDocletException {
        return XDocletTagSupport.dereferenceProperties(XDocletTagSupport.delimit(XDocletTagSupport.getTagValue(attributes, 3), attributes));
    }

    public void forAllConstructorTags(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTags(template, attributes, 3, "ONLY_CALL_CONSTRUCTOR_NOT_NULL", new String[]{"forAllConstructorTags"});
    }

    public void forAllConstructorTagTokens(String template, Properties attributes) throws XDocletException {
        this.forAllMemberTagTokens(template, attributes, 3);
    }

    public String firstSentenceDescriptionOfCurrentConstructor() throws XDocletException {
        return this.firstSentenceDescriptionOfCurrentMember((XMember)XDocletTagSupport.getCurrentConstructor());
    }

    public String modifiers() throws XDocletException {
        return this.modifiers(3);
    }

    public String constructorName(Properties attributes) throws XDocletException {
        String value;
        if (attributes != null && (value = (String)((Hashtable)attributes).get("value")) != null) {
            String m = XDocletTagSupport.getCurrentConstructor().getName().substring(Integer.parseInt(value));
            char firstU = m.charAt(0);
            char firstL = Character.toLowerCase(firstU);
            return firstL + m.substring(1);
        }
        return XDocletTagSupport.getCurrentConstructor() != null ? XDocletTagSupport.getCurrentConstructor().getName() : "";
    }

    public String currentConstructorName() throws XDocletException {
        return XDocletTagSupport.getCurrentConstructor().getName();
    }

    public void ifHasConstructor(String template, Properties attributes) throws XDocletException {
        this.ifHasConstructor_Impl(template, attributes, true);
    }

    public void ifDoesntHaveConstructor(String template, Properties attributes) throws XDocletException {
        this.ifHasConstructor_Impl(template, attributes, false);
    }

    private final void ifHasConstructor_Impl(String template, Properties attributes, boolean hasConstructor) throws XDocletException {
        Log log = LogUtil.getLog(class$Lxdoclet$tagshandler$ConstructorTagsHandler != null ? class$Lxdoclet$tagshandler$ConstructorTagsHandler : (class$Lxdoclet$tagshandler$ConstructorTagsHandler = ConstructorTagsHandler.class$("xdoclet.tagshandler.ConstructorTagsHandler")), "ifHasConstructor_Impl");
        String constructorName = attributes.getProperty("name");
        String parametersStr = attributes.getProperty("parameters");
        String delimiter = attributes.getProperty("delimiter");
        String[] parameters = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("constructorName=" + constructorName));
            log.debug((Object)("parametersStr=" + parametersStr));
            log.debug((Object)("delimiter=" + delimiter));
            log.debug((Object)("hasConstructor=" + hasConstructor));
            log.debug((Object)("getCurrentClass()=" + XDocletTagSupport.getCurrentClass()));
        }
        if (parametersStr != null) {
            if (delimiter == null) {
                delimiter = ",";
            }
            parameters = DocletUtil.tokenizeDelimitedToArray(parametersStr, delimiter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("parameters.length=" + parameters.length));
                log.debug((Object)("parameters[0]=" + parameters[0]));
            }
        }
        if (ConstructorTagsHandler.hasConstructor(XDocletTagSupport.getCurrentClass(), constructorName, parameters, false) == hasConstructor) {
            log.debug((Object)"constructor found.");
            this.generate(template);
        } else {
            log.debug((Object)"constructor not found.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

