/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.filesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.io.Files;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleUrl {
    private static final String FOLDER_SEPARATOR = "/";
    private static final char WINDOWS_FOLDER_SEPARATOR = '\\';
    private static final String CURRENT_PATH = ".";
    private static final Pattern URL_REGEXP = Pattern.compile("^([^/][^/]*:(?://)?)?(.*)");
    private static String url;
    private static String protocol;
    private static String path;
    private static String simplifiedUrl;

    public SimpleUrl(String url) {
        SimpleUrl.url = url;
        String urlWithUnixSeparators = CharMatcher.is((char)'\\').replaceFrom((CharSequence)url, (CharSequence)FOLDER_SEPARATOR);
        SimpleUrl.extractComponents(urlWithUnixSeparators);
        simplifiedUrl = protocol + SimpleUrl.simplifyPath(path);
    }

    private static void extractComponents(String urlWithUnixSeparators) {
        Matcher m = URL_REGEXP.matcher(urlWithUnixSeparators);
        m.matches();
        protocol = Optional.ofNullable(m.group(1)).orElse("");
        path = Optional.ofNullable(m.group(2)).orElse("");
    }

    @VisibleForTesting
    static String simplifyPath(String path) {
        String simplified = Files.simplifyPath((String)path);
        if (CURRENT_PATH.equals(simplified)) {
            return "";
        }
        return simplified;
    }

    public String getUrl() {
        return url;
    }

    public String getSimplified() {
        return simplifiedUrl;
    }
}

