/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.schema.CreateType;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTypeStart;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateType
implements CreateTypeStart,
CreateType {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier typeName;
    private final boolean ifNotExists;
    private final ImmutableMap<CqlIdentifier, DataType> fieldsInOrder;

    public DefaultCreateType(@NonNull CqlIdentifier typeName) {
        this(null, typeName);
    }

    public DefaultCreateType(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier typeName) {
        this(keyspace, typeName, false, (ImmutableMap<CqlIdentifier, DataType>)ImmutableMap.of());
    }

    public DefaultCreateType(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier typeName, boolean ifNotExists, @NonNull ImmutableMap<CqlIdentifier, DataType> fieldsInOrder) {
        this.keyspace = keyspace;
        this.typeName = typeName;
        this.ifNotExists = ifNotExists;
        this.fieldsInOrder = fieldsInOrder;
    }

    @Override
    @NonNull
    public CreateType withField(@NonNull CqlIdentifier fieldName, @NonNull DataType dataType) {
        return new DefaultCreateType(this.keyspace, this.typeName, this.ifNotExists, ImmutableCollections.append(this.fieldsInOrder, fieldName, dataType));
    }

    @Override
    @NonNull
    public CreateTypeStart ifNotExists() {
        return new DefaultCreateType(this.keyspace, this.typeName, true, this.fieldsInOrder);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TYPE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        CqlHelper.qualify(this.keyspace, this.typeName, builder);
        if (this.fieldsInOrder.isEmpty()) {
            return builder.toString();
        }
        builder.append(" (");
        boolean first = true;
        for (Map.Entry field : this.fieldsInOrder.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(((CqlIdentifier)field.getKey()).asCql(true)).append(' ').append(((DataType)field.getValue()).asCql(true, true));
        }
        builder.append(')');
        return builder.toString();
    }

    public String toString() {
        return this.asCql();
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getType() {
        return this.typeName;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, DataType> getFieldsInOrder() {
        return this.fieldsInOrder;
    }
}

