/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.Request;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.form.ContentProcessor;
import feign.form.ContentType;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class UrlencodedFormContentProcessor
implements ContentProcessor {
    private static final char QUERY_DELIMITER = '&';
    private static final char EQUAL_SIGN = '=';

    private static String encode(Object string, Charset charset) {
        return URLEncoder.encode(string.toString(), charset.name());
    }

    @Override
    public void process(RequestTemplate template, Charset charset, Map<String, Object> data) throws EncodeException {
        StringBuilder bodyData = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry == null || entry.getKey() == null) continue;
            if (bodyData.length() > 0) {
                bodyData.append('&');
            }
            bodyData.append(this.createKeyValuePair(entry, charset));
        }
        String contentTypeValue = this.getSupportedContentType().getHeader() + "; charset=" + charset.name();
        byte[] bytes = bodyData.toString().getBytes(charset);
        Request.Body body = Request.Body.encoded((byte[])bytes, (Charset)charset);
        template.header("Content-Type", Collections.emptyList());
        template.header("Content-Type", new String[]{contentTypeValue});
        template.body(body);
    }

    @Override
    public ContentType getSupportedContentType() {
        return ContentType.URLENCODED;
    }

    private String createKeyValuePair(Map.Entry<String, Object> entry, Charset charset) {
        String encodedKey = UrlencodedFormContentProcessor.encode(entry.getKey(), charset);
        Object value = entry.getValue();
        if (value == null) {
            return encodedKey;
        }
        if (value.getClass().isArray()) {
            return this.createKeyValuePairFromArray(encodedKey, value, charset);
        }
        if (value instanceof Collection) {
            return this.createKeyValuePairFromCollection(encodedKey, value, charset);
        }
        return encodedKey + '=' + UrlencodedFormContentProcessor.encode(value, charset);
    }

    private String createKeyValuePairFromCollection(String key, Object values, Charset charset) {
        Collection collection = (Collection)values;
        Object[] array = collection.toArray(new Object[0]);
        return this.createKeyValuePairFromArray(key, array, charset);
    }

    private String createKeyValuePairFromArray(String key, Object values, Charset charset) {
        StringBuilder result = new StringBuilder();
        Object[] array = (Object[])values;
        for (int index = 0; index < array.length; ++index) {
            Object value = array[index];
            if (value == null) continue;
            if (index > 0) {
                result.append('&');
            }
            result.append(key).append('=').append(UrlencodedFormContentProcessor.encode(value, charset));
        }
        return result.toString();
    }
}

