/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.detach.Detachable;
import com.datastax.oss.driver.internal.core.util.Loggers;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;

public interface ColumnDefinitions
extends Iterable<ColumnDefinition>,
Detachable {
    public int size();

    @NonNull
    public ColumnDefinition get(int var1);

    @NonNull
    default public ColumnDefinition get(@NonNull String name) {
        if (!this.contains(name)) {
            throw new IllegalArgumentException("No definition named " + name);
        }
        return this.get(this.firstIndexOf(name));
    }

    @NonNull
    default public ColumnDefinition get(@NonNull CqlIdentifier name) {
        if (!this.contains(name)) {
            throw new IllegalArgumentException("No definition named " + name);
        }
        return this.get(this.firstIndexOf(name));
    }

    public boolean contains(@NonNull String var1);

    public boolean contains(@NonNull CqlIdentifier var1);

    @NonNull
    default public List<Integer> allIndicesOf(@NonNull String name) {
        Loggers.COLUMN_DEFINITIONS.warn("{} should override allIndicesOf(String), the default implementation is a workaround for backward compatibility, it only returns the first occurrence", (Object)this.getClass().getName());
        return Collections.singletonList(this.firstIndexOf(name));
    }

    public int firstIndexOf(@NonNull String var1);

    @NonNull
    default public List<Integer> allIndicesOf(@NonNull CqlIdentifier id) {
        Loggers.COLUMN_DEFINITIONS.warn("{} should override allIndicesOf(CqlIdentifier), the default implementation is a workaround for backward compatibility, it only returns the first occurrence", (Object)this.getClass().getName());
        return Collections.singletonList(this.firstIndexOf(id));
    }

    public int firstIndexOf(@NonNull CqlIdentifier var1);
}

