/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;

public class Text {
    private final String content;

    public static Text fromRawText(String rawText) {
        Preconditions.checkNotNull((Object)rawText);
        String trimmedText = rawText.trim();
        Preconditions.checkArgument((!trimmedText.isEmpty() ? 1 : 0) != 0, (Object)"Text should not be empty");
        return new Text(Text.replaceLineBreaksByContinuation(trimmedText));
    }

    private static String replaceLineBreaksByContinuation(String rawText) {
        return Joiner.on((String)"\r\n ").join((Iterable)Splitter.on((String)"\n").trimResults().splitToList((CharSequence)rawText));
    }

    public Text(String content) {
        this.content = content;
    }

    public String formatted() {
        return this.content;
    }

    public final boolean equals(Object o) {
        if (o instanceof Text) {
            Text that = (Text)o;
            return Objects.equal((Object)this.content, (Object)that.content);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.content});
    }
}

