/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.xml.internal.unmarshall;

import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.XmlAttributeTrait;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.protocols.core.StringToInstant;
import software.amazon.awssdk.protocols.core.StringToValueConverter;
import software.amazon.awssdk.protocols.query.unmarshall.XmlElement;
import software.amazon.awssdk.protocols.query.unmarshall.XmlErrorUnmarshaller;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.HeaderUnmarshaller;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlPayloadUnmarshaller;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlResponseParserUtils;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlUnmarshaller;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlUnmarshallerContext;
import software.amazon.awssdk.protocols.xml.internal.unmarshall.XmlUnmarshallerRegistry;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.Buildable;

@SdkInternalApi
public final class XmlProtocolUnmarshaller
implements XmlErrorUnmarshaller {
    public static final StringToValueConverter.StringToValue<Instant> INSTANT_STRING_TO_VALUE = StringToInstant.create(XmlProtocolUnmarshaller.getDefaultTimestampFormats());
    private static final XmlUnmarshallerRegistry REGISTRY = XmlProtocolUnmarshaller.createUnmarshallerRegistry();

    private XmlProtocolUnmarshaller() {
    }

    public static XmlProtocolUnmarshaller create() {
        return new XmlProtocolUnmarshaller();
    }

    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, SdkHttpFullResponse response) {
        XmlElement document = XmlResponseParserUtils.parse(sdkPojo, response);
        return this.unmarshall(sdkPojo, document, response);
    }

    public <TypeT extends SdkPojo> TypeT unmarshall(SdkPojo sdkPojo, XmlElement resultRoot, SdkHttpFullResponse response) {
        XmlUnmarshallerContext unmarshallerContext = XmlUnmarshallerContext.builder().response(response).registry(REGISTRY).protocolUnmarshaller(this).build();
        return (TypeT)this.unmarshall(unmarshallerContext, sdkPojo, resultRoot);
    }

    SdkPojo unmarshall(XmlUnmarshallerContext context, SdkPojo sdkPojo, XmlElement root) {
        Optional<SdkField<?>> payloadMemberAsBlobType = XmlResponseParserUtils.getBlobTypePayloadMemberToUnmarshal(sdkPojo);
        for (SdkField field : sdkPojo.sdkFields()) {
            XmlUnmarshaller<Object> unmarshaller = REGISTRY.getUnmarshaller(field.location(), field.marshallingType());
            if (root != null && field.location() == MarshallLocation.PAYLOAD) {
                boolean isFieldBlobTypePayload;
                if (!context.response().content().isPresent()) {
                    if (field.marshallingType() != MarshallingType.SDK_BYTES || !field.containsTrait(PayloadTrait.class)) continue;
                    field.set((Object)sdkPojo, (Object)SdkBytes.fromByteArrayUnsafe((byte[])new byte[0]));
                    continue;
                }
                if (this.isAttribute(field)) {
                    root.getOptionalAttributeByName(field.unmarshallLocationName()).ifPresent(e -> field.set((Object)sdkPojo, e));
                    continue;
                }
                List element = this.isExplicitPayloadMember(field) ? Collections.singletonList(root) : root.getElementsByName(field.unmarshallLocationName());
                if (CollectionUtils.isNullOrEmpty((Collection)element)) continue;
                boolean bl = isFieldBlobTypePayload = payloadMemberAsBlobType.isPresent() && payloadMemberAsBlobType.get().equals((Object)field);
                if (isFieldBlobTypePayload) {
                    field.set((Object)sdkPojo, (Object)SdkBytes.fromInputStream((InputStream)((InputStream)context.response().content().get())));
                    continue;
                }
                Object unmarshalled = unmarshaller.unmarshall(context, element, (SdkField<Object>)field);
                field.set((Object)sdkPojo, unmarshalled);
                continue;
            }
            Object unmarshalled = unmarshaller.unmarshall(context, null, (SdkField<Object>)field);
            field.set((Object)sdkPojo, unmarshalled);
        }
        if (!(sdkPojo instanceof Buildable)) {
            throw new RuntimeException("The sdkPojo passed to the unmarshaller is not buildable (must implement Buildable)");
        }
        return (SdkPojo)((Buildable)sdkPojo).build();
    }

    private boolean isAttribute(SdkField<?> field) {
        return field.containsTrait(XmlAttributeTrait.class);
    }

    private boolean isExplicitPayloadMember(SdkField<?> field) {
        return field.containsTrait(PayloadTrait.class);
    }

    private static Map<MarshallLocation, TimestampFormatTrait.Format> getDefaultTimestampFormats() {
        EnumMap<MarshallLocation, TimestampFormatTrait.Format> formats = new EnumMap<MarshallLocation, TimestampFormatTrait.Format>(MarshallLocation.class);
        formats.put(MarshallLocation.HEADER, TimestampFormatTrait.Format.RFC_822);
        formats.put(MarshallLocation.PAYLOAD, TimestampFormatTrait.Format.ISO_8601);
        return Collections.unmodifiableMap(formats);
    }

    private static XmlUnmarshallerRegistry createUnmarshallerRegistry() {
        return XmlUnmarshallerRegistry.builder().statusCodeUnmarshaller(MarshallingType.INTEGER, (context, content, field) -> context.response().statusCode()).headerUnmarshaller(MarshallingType.STRING, HeaderUnmarshaller.STRING).headerUnmarshaller(MarshallingType.INTEGER, HeaderUnmarshaller.INTEGER).headerUnmarshaller(MarshallingType.LONG, HeaderUnmarshaller.LONG).headerUnmarshaller(MarshallingType.SHORT, HeaderUnmarshaller.SHORT).headerUnmarshaller(MarshallingType.DOUBLE, HeaderUnmarshaller.DOUBLE).headerUnmarshaller(MarshallingType.BOOLEAN, HeaderUnmarshaller.BOOLEAN).headerUnmarshaller(MarshallingType.INSTANT, HeaderUnmarshaller.INSTANT).headerUnmarshaller(MarshallingType.FLOAT, HeaderUnmarshaller.FLOAT).headerUnmarshaller(MarshallingType.MAP, HeaderUnmarshaller.MAP).headerUnmarshaller(MarshallingType.LIST, HeaderUnmarshaller.LIST).payloadUnmarshaller(MarshallingType.STRING, XmlPayloadUnmarshaller.STRING).payloadUnmarshaller(MarshallingType.INTEGER, XmlPayloadUnmarshaller.INTEGER).payloadUnmarshaller(MarshallingType.LONG, XmlPayloadUnmarshaller.LONG).payloadUnmarshaller(MarshallingType.SHORT, XmlPayloadUnmarshaller.SHORT).payloadUnmarshaller(MarshallingType.FLOAT, XmlPayloadUnmarshaller.FLOAT).payloadUnmarshaller(MarshallingType.DOUBLE, XmlPayloadUnmarshaller.DOUBLE).payloadUnmarshaller(MarshallingType.BIG_DECIMAL, XmlPayloadUnmarshaller.BIG_DECIMAL).payloadUnmarshaller(MarshallingType.BOOLEAN, XmlPayloadUnmarshaller.BOOLEAN).payloadUnmarshaller(MarshallingType.INSTANT, XmlPayloadUnmarshaller.INSTANT).payloadUnmarshaller(MarshallingType.SDK_BYTES, XmlPayloadUnmarshaller.SDK_BYTES).payloadUnmarshaller(MarshallingType.SDK_POJO, XmlPayloadUnmarshaller::unmarshallSdkPojo).payloadUnmarshaller(MarshallingType.LIST, XmlPayloadUnmarshaller::unmarshallList).payloadUnmarshaller(MarshallingType.MAP, XmlPayloadUnmarshaller::unmarshallMap).build();
    }
}

