/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.indices.PutIndicesSettingsRequest;
import org.opensearch.client.opensearch.snapshot.RestoreResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RestoreRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> ignoreIndexSettings;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeAliases;
    @Nullable
    private final Boolean includeGlobalState;
    @Nullable
    private final PutIndicesSettingsRequest indexSettings;
    private final List<String> indices;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time clusterManagerTimeout;
    @Nullable
    private final Boolean partial;
    @Nullable
    private final String renamePattern;
    @Nullable
    private final String renameReplacement;
    private final String repository;
    private final String snapshot;
    @Nullable
    private final Boolean waitForCompletion;
    public static final JsonpDeserializer<RestoreRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RestoreRequest::setupRestoreRequestDeserializer);
    public static final Endpoint<RestoreRequest, RestoreResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RestoreRequest, RestoreResponse>(request -> "POST", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            buf.append("/_restore");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", request.clusterManagerTimeout._toJsonString());
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, RestoreResponse._DESERIALIZER);

    private RestoreRequest(Builder builder) {
        this.ignoreIndexSettings = ApiTypeHelper.unmodifiable(builder.ignoreIndexSettings);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeAliases = builder.includeAliases;
        this.includeGlobalState = builder.includeGlobalState;
        this.indexSettings = builder.indexSettings;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.masterTimeout = builder.masterTimeout;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.partial = builder.partial;
        this.renamePattern = builder.renamePattern;
        this.renameReplacement = builder.renameReplacement;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static RestoreRequest of(Function<Builder, ObjectBuilder<RestoreRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean includeAliases() {
        return this.includeAliases;
    }

    @Nullable
    public final Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    @Nullable
    public final PutIndicesSettingsRequest indexSettings() {
        return this.indexSettings;
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Deprecated
    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    @Nullable
    public final Boolean partial() {
        return this.partial;
    }

    @Nullable
    public final String renamePattern() {
        return this.renamePattern;
    }

    @Nullable
    public final String renameReplacement() {
        return this.renameReplacement;
    }

    public final String repository() {
        return this.repository;
    }

    public final String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.ignoreIndexSettings)) {
            generator.writeKey("ignore_index_settings");
            generator.writeStartArray();
            for (String item0 : this.ignoreIndexSettings) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        if (this.includeAliases != null) {
            generator.writeKey("include_aliases");
            generator.write(this.includeAliases.booleanValue());
        }
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        if (this.indexSettings != null) {
            generator.writeKey("index_settings");
            this.indexSettings.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.partial != null) {
            generator.writeKey("partial");
            generator.write(this.partial.booleanValue());
        }
        if (this.renamePattern != null) {
            generator.writeKey("rename_pattern");
            generator.write(this.renamePattern);
        }
        if (this.renameReplacement != null) {
            generator.writeKey("rename_replacement");
            generator.write(this.renameReplacement);
        }
    }

    protected static void setupRestoreRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ignoreIndexSettings, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ignore_index_settings");
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable");
        op.add(Builder::includeAliases, JsonpDeserializer.booleanDeserializer(), "include_aliases");
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state");
        op.add(Builder::indexSettings, PutIndicesSettingsRequest._DESERIALIZER, "index_settings");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::partial, JsonpDeserializer.booleanDeserializer(), "partial");
        op.add(Builder::renamePattern, JsonpDeserializer.stringDeserializer(), "rename_pattern");
        op.add(Builder::renameReplacement, JsonpDeserializer.stringDeserializer(), "rename_replacement");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RestoreRequest> {
        @Nullable
        private List<String> ignoreIndexSettings;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeAliases;
        @Nullable
        private Boolean includeGlobalState;
        @Nullable
        private PutIndicesSettingsRequest indexSettings;
        @Nullable
        private List<String> indices;
        @Deprecated
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time clusterManagerTimeout;
        @Nullable
        private Boolean partial;
        @Nullable
        private String renamePattern;
        @Nullable
        private String renameReplacement;
        private String repository;
        private String snapshot;
        @Nullable
        private Boolean waitForCompletion;

        public final Builder ignoreIndexSettings(List<String> list) {
            this.ignoreIndexSettings = Builder._listAddAll(this.ignoreIndexSettings, list);
            return this;
        }

        public final Builder ignoreIndexSettings(String value, String ... values) {
            this.ignoreIndexSettings = Builder._listAdd(this.ignoreIndexSettings, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder includeAliases(@Nullable Boolean value) {
            this.includeAliases = value;
            return this;
        }

        public final Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        public final Builder indexSettings(@Nullable PutIndicesSettingsRequest value) {
            this.indexSettings = value;
            return this;
        }

        public final Builder indexSettings(Function<PutIndicesSettingsRequest.Builder, ObjectBuilder<PutIndicesSettingsRequest>> fn) {
            return this.indexSettings(fn.apply(new PutIndicesSettingsRequest.Builder()).build());
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Deprecated
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder partial(@Nullable Boolean value) {
            this.partial = value;
            return this;
        }

        public final Builder renamePattern(@Nullable String value) {
            this.renamePattern = value;
            return this;
        }

        public final Builder renameReplacement(@Nullable String value) {
            this.renameReplacement = value;
            return this;
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public RestoreRequest build() {
            this._checkSingleUse();
            return new RestoreRequest(this);
        }
    }
}

