/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import java.io.Reader;
import org.apache.james.mailbox.lucene.search.UpperCaseFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.util.Version;

public final class LenientImapSearchAnalyzer
extends Analyzer {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 4;
    private final int maxTokenLength;

    public LenientImapSearchAnalyzer(int maxTokenLength) {
        this.maxTokenLength = maxTokenLength;
    }

    public LenientImapSearchAnalyzer() {
        this(4);
    }

    public TokenStream tokenStream(String arg0, Reader reader) {
        return new ShingleFilter((TokenStream)new UpperCaseFilter((TokenStream)new WhitespaceTokenizer(Version.LUCENE_31, reader)), 2, this.maxTokenLength);
    }
}

