/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import javax.inject.Inject;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.display.Locales;
import org.apache.james.imap.api.display.Localizer;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.ContinuationResponse;

public class ContinuationResponseEncoder
implements ImapResponseEncoder<ContinuationResponse> {
    private final Localizer localizer;

    @Inject
    public ContinuationResponseEncoder(Localizer localizer) {
        this.localizer = localizer;
    }

    @Override
    public Class<ContinuationResponse> acceptableMessages() {
        return ContinuationResponse.class;
    }

    @Override
    public void encode(ContinuationResponse response, ImapResponseComposer composer) throws IOException {
        String message = this.asString(response.getTextKey());
        composer.continuationResponse(message);
    }

    private String asString(HumanReadableText text) {
        return this.localizer.localize(text, Locales.DEFAULT);
    }
}

