/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

@ChannelHandler.Sharable
public class ConnectionLimitUpstreamHandler
extends ChannelInboundHandlerAdapter {
    private final AtomicInteger connections = new AtomicInteger(0);
    private final int maxConnections;

    public static Optional<ConnectionLimitUpstreamHandler> forCount(int connPerIP) {
        if (connPerIP > 0) {
            return Optional.of(new ConnectionLimitUpstreamHandler(connPerIP));
        }
        return Optional.empty();
    }

    private ConnectionLimitUpstreamHandler(int maxConnections) {
        Preconditions.checkArgument((maxConnections > 0 ? 1 : 0) != 0);
        this.maxConnections = maxConnections;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        int currentCount = this.connections.incrementAndGet();
        if (currentCount > this.maxConnections) {
            ctx.close();
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.maxConnections > 0) {
            this.connections.decrementAndGet();
        }
        super.channelInactive(ctx);
    }
}

