/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.onami.lifecycle;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.james.onami.lifecycle.AbstractStageable;
import org.apache.james.onami.lifecycle.DisposingStager;
import org.apache.james.onami.lifecycle.NoOpStageHandler;
import org.apache.james.onami.lifecycle.StageHandler;
import org.apache.james.onami.lifecycle.Stageable;

public class DefaultStager<A extends Annotation>
implements DisposingStager<A> {
    private final Class<A> stage;
    private final Queue<Stageable> stageables;

    public DefaultStager(Class<A> stage) {
        this(stage, Order.FIRST_IN_FIRST_OUT);
    }

    public DefaultStager(Class<A> stage, Order mode) {
        Queue localStageables;
        this.stage = stage;
        switch (mode) {
            case FIRST_IN_FIRST_OUT: {
                localStageables = new ArrayDeque();
                break;
            }
            case FIRST_IN_LAST_OUT: {
                localStageables = Collections.asLifoQueue(new ArrayDeque());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        this.stageables = localStageables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Stageable stageable) {
        Queue<Stageable> queue = this.stageables;
        synchronized (queue) {
            this.stageables.add(stageable);
        }
    }

    @Override
    public <T extends ExecutorService> T register(T executorService) {
        this.register(new ExecutorServiceStageable(executorService));
        return executorService;
    }

    @Override
    public <T extends Closeable> T register(T closeable) {
        this.register(new CloseableStageable(closeable));
        return closeable;
    }

    @Override
    public void stage() {
        this.stage(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stage(StageHandler stageHandler) {
        if (stageHandler == null) {
            stageHandler = new NoOpStageHandler();
        }
        while (true) {
            Stageable stageable;
            Queue<Stageable> queue = this.stageables;
            synchronized (queue) {
                stageable = this.stageables.poll();
            }
            if (stageable == null) break;
            stageable.stage(stageHandler);
        }
    }

    @Override
    public Class<A> getStage() {
        return this.stage;
    }

    public static enum Order {
        FIRST_IN_FIRST_OUT,
        FIRST_IN_LAST_OUT;

    }

    private static class ExecutorServiceStageable
    extends AbstractStageable<ExecutorService> {
        public ExecutorServiceStageable(ExecutorService executor) {
            super(executor);
        }

        @Override
        protected void doStage() throws Exception {
            ((ExecutorService)this.object).shutdown();
            try {
                if (!((ExecutorService)this.object).awaitTermination(1L, TimeUnit.MINUTES)) {
                    ((ExecutorService)this.object).shutdownNow();
                }
            }
            catch (InterruptedException e) {
                ((ExecutorService)this.object).shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class CloseableStageable
    extends AbstractStageable<Closeable> {
        public CloseableStageable(Closeable closeable) {
            super(closeable);
        }

        @Override
        protected void doStage() throws Exception {
            ((Closeable)this.object).close();
        }
    }
}

