/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.NettyImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyStreamImapRequestLineReader;
import org.apache.james.imapserver.netty.SwitchableLineBasedFrameDecoder;
import org.apache.james.protocols.netty.LineHandlerAware;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class ImapRequestFrameDecoder
extends ByteToMessageDecoder
implements NettyConstants,
LineHandlerAware {
    @VisibleForTesting
    static final String NEEDED_DATA = "NEEDED_DATA";
    private static final boolean RETRY = true;
    private static final String SINK = "SINK";
    private static final String SUBSCRIPTION = "SUBSCRIPTION";
    private final ImapDecoder decoder;
    private final int inMemorySizeLimit;
    private final int literalSizeLimit;
    private final Deque<ChannelInboundHandlerAdapter> behaviourOverrides = new ConcurrentLinkedDeque<ChannelInboundHandlerAdapter>();
    private final int maxFrameLength;
    private final AtomicBoolean framingEnabled = new AtomicBoolean(true);

    public ImapRequestFrameDecoder(ImapDecoder decoder, int inMemorySizeLimit, int literalSizeLimit, int maxFrameLength) {
        this.decoder = decoder;
        this.inMemorySizeLimit = inMemorySizeLimit;
        this.literalSizeLimit = literalSizeLimit;
        this.maxFrameLength = maxFrameLength;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(FRAME_DECODE_ATTACHMENT_ATTRIBUTE_KEY).set(new HashMap());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Object subscription = ((Map)ctx.channel().attr(FRAME_DECODE_ATTACHMENT_ATTRIBUTE_KEY).get()).get(SUBSCRIPTION);
        if (subscription instanceof Disposable) {
            ((Disposable)subscription).dispose();
        }
        super.channelInactive(ctx);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ChannelInboundHandlerAdapter override = this.behaviourOverrides.peekFirst();
        if (override != null) {
            override.channelRead(ctx, (Object)in);
            return;
        }
        int readerIndex = in.readerIndex();
        Map attachment = (Map)ctx.channel().attr(FRAME_DECODE_ATTACHMENT_ATTRIBUTE_KEY).get();
        Pair<ImapRequestLineReader, Integer> readerAndSize = this.obtainReader(ctx, in, attachment, readerIndex);
        if (readerAndSize == null) {
            return;
        }
        this.parseImapMessage(ctx, in, attachment, readerAndSize, readerIndex).ifPresent(out::add);
    }

    private Optional<ImapMessage> parseImapMessage(ChannelHandlerContext ctx, ByteBuf in, Map<String, Object> attachment, Pair<ImapRequestLineReader, Integer> readerAndSize, int readerIndex) throws DecodingException {
        ImapSession session = (ImapSession)ctx.channel().attr(IMAP_SESSION_ATTRIBUTE_KEY).get();
        if (session != null && session.getState() != ImapSessionState.LOGOUT) {
            try {
                ImapMessage message = this.decoder.decode((ImapRequestLineReader)readerAndSize.getLeft(), session);
                if ((Integer)readerAndSize.getRight() == -1) {
                    ((ImapRequestLineReader)readerAndSize.getLeft()).consumeLine();
                }
                this.enableFraming(ctx);
                attachment.clear();
                return Optional.of(message);
            }
            catch (NettyImapRequestLineReader.NotEnoughDataException e) {
                this.requestMoreData(ctx, in, attachment, e.getNeededSize(), readerIndex);
            }
        } else if (ctx.channel().isActive()) {
            ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return Optional.empty();
    }

    private void requestMoreData(ChannelHandlerContext ctx, ByteBuf in, Map<String, Object> attachment, int neededData, int readerIndex) {
        attachment.put(NEEDED_DATA, neededData);
        this.disableFraming(ctx);
        in.readerIndex(readerIndex);
    }

    private Pair<ImapRequestLineReader, Integer> obtainReader(ChannelHandlerContext ctx, ByteBuf in, Map<String, Object> attachment, int readerIndex) throws IOException {
        NettyImapRequestLineReader reader;
        boolean retry = false;
        int size = -1;
        Object rawSize = attachment.get(NEEDED_DATA);
        if (rawSize != null) {
            retry = true;
            size = (Integer)rawSize;
            if (size != -1 && size > in.readableBytes()) {
                if (this.inMemorySizeLimit > 0 && this.inMemorySizeLimit < size) {
                    this.uploadToAFile(ctx, in, attachment, size, readerIndex);
                    return null;
                }
                in.resetReaderIndex();
                return null;
            }
            reader = new NettyImapRequestLineReader(ctx.channel(), in, retry, this.literalSizeLimit);
        } else {
            reader = new NettyImapRequestLineReader(ctx.channel(), in, retry, this.literalSizeLimit);
        }
        return Pair.of((Object)((Object)reader), (Object)size);
    }

    private void uploadToAFile(ChannelHandlerContext ctx, ByteBuf in, Map<String, Object> attachment, int size, int readerIndex) throws IOException {
        Sinks.Many sink;
        if (attachment.containsKey(SINK)) {
            sink = (Sinks.Many)attachment.get(SINK);
        } else {
            sink = Sinks.many().unicast().onBackpressureBuffer();
            attachment.put(SINK, sink);
            FileChunkConsumer fileChunkConsumer = new FileChunkConsumer(size, (file, written) -> {
                NettyStreamImapRequestLineReader reader = new NettyStreamImapRequestLineReader(ctx.channel(), (File)file, true);
                try {
                    this.parseImapMessage(ctx, null, attachment, (Pair<ImapRequestLineReader, Integer>)Pair.of((Object)reader, (Object)size), readerIndex).ifPresent(arg_0 -> ((ChannelHandlerContext)ctx).fireChannelRead(arg_0));
                }
                catch (DecodingException e) {
                    ctx.fireExceptionCaught((Throwable)e);
                }
            });
            Disposable subscribe = sink.asFlux().publishOn(Schedulers.boundedElastic()).subscribe((Consumer)fileChunkConsumer, e -> {
                fileChunkConsumer.discard();
                ctx.fireExceptionCaught(e);
            }, () -> {});
            attachment.put(SUBSCRIPTION, () -> {
                subscribe.dispose();
                fileChunkConsumer.discard();
            });
        }
        int readableBytes = in.readableBytes();
        byte[] bytes = new byte[readableBytes];
        in.readBytes(bytes);
        sink.emitNext((Object)bytes, Sinks.EmitFailureHandler.FAIL_FAST);
    }

    public void disableFraming(ChannelHandlerContext ctx) {
        if (this.framingEnabled.getAndSet(false)) {
            ctx.channel().pipeline().remove("framer");
        }
    }

    public void enableFraming(ChannelHandlerContext ctx) {
        if (!this.framingEnabled.getAndSet(true)) {
            ctx.channel().pipeline().addBefore("requestDecoder", "framer", (ChannelHandler)new SwitchableLineBasedFrameDecoder(ctx.channel().pipeline(), this.maxFrameLength, false));
        }
    }

    public void pushLineHandler(ChannelInboundHandlerAdapter lineHandlerUpstreamHandler) {
        this.behaviourOverrides.addFirst(lineHandlerUpstreamHandler);
    }

    public void popLineHandler() {
        if (!this.behaviourOverrides.isEmpty()) {
            this.behaviourOverrides.removeFirst();
        }
    }

    static class FileChunkConsumer
    implements Consumer<byte[]> {
        private final int size;
        private final AtomicInteger written = new AtomicInteger(0);
        private final BiConsumer<File, Integer> callback;
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private OutputStream outputStream;
        private File f;

        FileChunkConsumer(int size, BiConsumer<File, Integer> callback) {
            this.size = size;
            this.callback = callback;
        }

        @Override
        public void accept(byte[] next) {
            if (!this.initialized.get()) {
                this.initialize();
            }
            this.writeChunk(next);
            if (this.isComplete()) {
                this.finalizeDataTransfer();
            }
        }

        private void initialize() {
            try {
                this.f = Files.createTempFile("imap-literal", ".tmp", new FileAttribute[0]).toFile();
                this.outputStream = new FileOutputStream(this.f, true);
                this.initialized.set(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void writeChunk(byte[] next) {
            try {
                int amount = Math.min(next.length, this.size - this.written.get());
                this.outputStream.write(next, 0, amount);
                this.written.addAndGet(amount);
            }
            catch (Exception e) {
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException(e);
            }
        }

        private boolean isComplete() {
            return this.written.get() == this.size;
        }

        private void finalizeDataTransfer() {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.callback.accept(this.f, this.written.get());
        }

        void discard() {
            Mono.fromRunnable((Runnable)Throwing.runnable(() -> {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                if (this.f != null) {
                    Files.delete(this.f.toPath());
                }
            })).subscribeOn(Schedulers.boundedElastic()).subscribe();
        }
    }
}

