/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.Header;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FullByteContent
implements Content {
    private static final String NAME_DELIMITER = ": ";
    private static final byte[] NAME_DELIMITER_BYTES = ": ".getBytes(StandardCharsets.US_ASCII);
    private static final String END_OF_LINE = "\r\n";
    private static final byte[] END_OF_LINE_BYTES = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private final List<Header> headers;
    private final byte[] body;
    private final long size;

    public FullByteContent(byte[] body, List<Header> headers) {
        this.headers = headers;
        this.body = body;
        this.size = this.computeSize();
    }

    protected long computeSize() {
        long result = this.body.length;
        result += 2L;
        for (Header header : this.headers) {
            if (header == null) continue;
            result += header.size();
            result += 2L;
        }
        return result;
    }

    public InputStream getInputStream() throws IOException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream((int)this.size);
        for (Header header : this.headers) {
            if (header == null) continue;
            out.write(header.getName().getBytes(StandardCharsets.US_ASCII));
            out.write(NAME_DELIMITER_BYTES);
            out.write(header.getValue().getBytes(StandardCharsets.US_ASCII));
            out.write(END_OF_LINE_BYTES);
        }
        out.write(END_OF_LINE_BYTES);
        return new SequenceInputStream(out.toInputStream(), new ByteArrayInputStream(this.body));
    }

    public long size() {
        return this.size;
    }

    public Publisher<ByteBuffer> reactiveBytes() {
        Flux headerContent = Mono.fromCallable(() -> {
            StringBuilder sb = new StringBuilder();
            for (Header header : this.headers) {
                sb.append(header.getName()).append(NAME_DELIMITER).append(header.getValue()).append(END_OF_LINE);
            }
            sb.append(END_OF_LINE);
            return sb.toString().getBytes(StandardCharsets.US_ASCII);
        }).flatMapMany(bytes -> Flux.just((Object)bytes).map(ByteBuffer::wrap));
        Flux bodyContent = Flux.just((Object)this.body).map(ByteBuffer::wrap);
        return Flux.concat((Publisher[])new Publisher[]{headerContent, bodyContent});
    }
}

