/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Rule {
    private final Id id;
    private final String name;
    private final Condition condition;
    private final Action action;

    public static Builder builder() {
        return new Builder();
    }

    private Rule(Id id, String name, Condition condition, Action action) {
        this.id = id;
        this.name = name;
        this.condition = condition;
        this.action = action;
    }

    public Id getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Action getAction() {
        return this.action;
    }

    public final boolean equals(Object o) {
        if (o instanceof Rule) {
            Rule rule = (Rule)o;
            return Objects.equals(this.id, rule.id) && Objects.equals(this.name, rule.name) && Objects.equals(this.condition, rule.condition) && Objects.equals(this.action, rule.action);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.name, this.condition, this.action);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("condition", (Object)this.condition).add("action", (Object)this.action).toString();
    }

    public static class Builder {
        private Id id;
        private String name;
        private Condition condition;
        private Action action;

        public Builder id(Id id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Rule build() {
            Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"`id` is mandatory");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"`name` is mandatory");
            Preconditions.checkState((this.condition != null ? 1 : 0) != 0, (Object)"`condition` is mandatory");
            Preconditions.checkState((this.action != null ? 1 : 0) != 0, (Object)"`action` is mandatory");
            return new Rule(this.id, this.name, this.condition, this.action);
        }
    }

    public static class Id {
        private final String value;

        public static Id of(String id) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"`id` is mandatory");
            return new Id(id);
        }

        private Id(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Id) {
                Id id = (Id)o;
                return Objects.equals(this.value, id.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }

    public static class Condition {
        private final Field field;
        private final Comparator comparator;
        private final String value;

        public static Condition of(Field field, Comparator comparator, String value) {
            Preconditions.checkNotNull((Object)((Object)field), (Object)"field should not be null");
            Preconditions.checkNotNull((Object)((Object)comparator), (Object)"comparator should not be null");
            Preconditions.checkNotNull((Object)value, (Object)"value should not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"value should not be empty");
            return new Condition(field, comparator, value);
        }

        private Condition(Field field, Comparator comparator, String value) {
            this.field = field;
            this.comparator = comparator;
            this.value = value;
        }

        public Field getField() {
            return this.field;
        }

        public Comparator getComparator() {
            return this.comparator;
        }

        public String getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Condition) {
                Condition condition = (Condition)o;
                return Objects.equals((Object)this.field, (Object)condition.field) && Objects.equals((Object)this.comparator, (Object)condition.comparator) && Objects.equals(this.value, condition.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.field, this.comparator, this.value});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("comparator", (Object)this.comparator).add("value", (Object)this.value).toString();
        }

        public static enum Field {
            FROM("from"),
            TO("to"),
            CC("cc"),
            SUBJECT("subject"),
            RECIPIENT("recipient");

            private final String fieldName;

            public static Optional<Field> find(String fieldName) {
                return Arrays.stream(Field.values()).filter(value -> value.fieldName.equalsIgnoreCase(fieldName)).findAny();
            }

            public static Field of(String fieldName) {
                return Field.find(fieldName).orElseThrow(() -> new IllegalArgumentException("'" + fieldName + "' is not a valid field name"));
            }

            private Field(String fieldName) {
                this.fieldName = fieldName;
            }

            public String asString() {
                return this.fieldName;
            }
        }

        public static enum Comparator {
            CONTAINS("contains"),
            NOT_CONTAINS("not-contains"),
            EXACTLY_EQUALS("exactly-equals"),
            NOT_EXACTLY_EQUALS("not-exactly-equals");

            private final String comparatorName;

            public static Optional<Comparator> find(String comparatorName) {
                return Arrays.stream(Comparator.values()).filter(value -> value.comparatorName.equalsIgnoreCase(comparatorName)).findAny();
            }

            public static Comparator of(String comparatorName) {
                return Comparator.find(comparatorName).orElseThrow(() -> new IllegalArgumentException("'" + comparatorName + "' is not a valid comparator name"));
            }

            private Comparator(String comparator) {
                this.comparatorName = comparator;
            }

            public String asString() {
                return this.comparatorName;
            }
        }
    }

    public static class Action {
        private final AppendInMailboxes appendInMailboxes;

        public static Action of(AppendInMailboxes appendInMailboxes) {
            return new Action(appendInMailboxes);
        }

        private Action(AppendInMailboxes appendInMailboxes) {
            this.appendInMailboxes = appendInMailboxes;
        }

        public AppendInMailboxes getAppendInMailboxes() {
            return this.appendInMailboxes;
        }

        public final boolean equals(Object o) {
            if (o instanceof Action) {
                Action action = (Action)o;
                return Objects.equals(this.appendInMailboxes, action.appendInMailboxes);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.appendInMailboxes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("appendInMailboxes", (Object)this.appendInMailboxes).toString();
        }

        public static class AppendInMailboxes {
            private final ImmutableList<String> mailboxIds;

            public static AppendInMailboxes withMailboxIds(List<String> mailboxIds) {
                Preconditions.checkNotNull(mailboxIds, (Object)"mailboxIds should not be null");
                return new AppendInMailboxes(mailboxIds);
            }

            public static AppendInMailboxes withMailboxIds(String ... mailboxIds) {
                return AppendInMailboxes.withMailboxIds(Arrays.asList(mailboxIds));
            }

            private AppendInMailboxes(List<String> mailboxIds) {
                this.mailboxIds = ImmutableList.copyOf(mailboxIds);
            }

            public ImmutableList<String> getMailboxIds() {
                return this.mailboxIds;
            }

            public final boolean equals(Object o) {
                if (o instanceof AppendInMailboxes) {
                    AppendInMailboxes appendInMailboxes = (AppendInMailboxes)o;
                    return Objects.equals(this.mailboxIds, appendInMailboxes.mailboxIds);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.mailboxIds);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("mailboxIds", this.mailboxIds).toString();
            }
        }
    }
}

