/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import org.apache.james.blob.aes.AESBlobStoreDAO;
import org.apache.james.blob.aes.CryptoConfig;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.cassandra.CassandraBlobStoreDAO;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreDAO;
import org.apache.james.modules.blobstore.BlobDeduplicationGCModule;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.validation.BlobStoreConfigurationValidationStartUpCheck;
import org.apache.james.modules.blobstore.validation.StoragePolicyConfigurationSanityEnforcementModule;
import org.apache.james.modules.mailbox.BlobStoreAPIModule;
import org.apache.james.modules.mailbox.CassandraBlobStoreDependenciesModule;
import org.apache.james.modules.mailbox.CassandraBucketModule;
import org.apache.james.modules.objectstorage.DefaultBucketModule;
import org.apache.james.modules.objectstorage.S3BlobStoreModule;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore;
import org.apache.james.server.blob.deduplication.PassThroughBlobStore;
import org.apache.james.server.blob.deduplication.StorageStrategy;

public class BlobStoreModulesChooser {
    private static final String UNENCRYPTED = "unencrypted";

    public static List<Module> chooseModules(BlobStoreConfiguration choosingConfiguration) {
        return ImmutableList.builder().add((Object)BlobStoreModulesChooser.chooseEncryptionModule(choosingConfiguration.getCryptoConfig())).add((Object)BlobStoreModulesChooser.chooseBlobStoreDAOModule(choosingConfiguration.getImplementation())).addAll(BlobStoreModulesChooser.chooseStoragePolicyModule(choosingConfiguration.storageStrategy())).add((Object)new StoragePolicyConfigurationSanityEnforcementModule()).add(binder -> binder.bind(BlobStoreConfiguration.class).toInstance((Object)choosingConfiguration)).add(binder -> binder.bind(BlobStoreConfigurationValidationStartUpCheck.StorageStrategySupplier.class).toInstance(choosingConfiguration::storageStrategy)).build();
    }

    public static Module chooseBlobStoreDAOModule(BlobStoreConfiguration.BlobStoreImplName implementation) {
        switch (implementation) {
            case CASSANDRA: {
                return new CassandraBlobStoreDAODeclarationModule();
            }
            case S3: {
                return new ObjectStorageBlobStoreDAODeclarationModule();
            }
        }
        throw new RuntimeException("Unsupported blobStore implementation " + implementation);
    }

    public static Module chooseEncryptionModule(Optional<CryptoConfig> cryptoConfig) {
        Optional<Module> encryptionModule = cryptoConfig.map(EncryptionModule::new);
        return encryptionModule.orElse((Module)new NoEncryptionModule());
    }

    private static List<Module> chooseStoragePolicyModule(StorageStrategy storageStrategy) {
        switch (storageStrategy) {
            case DEDUPLICATION: {
                Module deduplicationBlobModule = binder -> binder.bind(BlobStore.class).annotatedWith((Annotation)Names.named((String)"blobStoreBackend")).to(DeDuplicationBlobStore.class);
                return ImmutableList.of((Object)new BlobDeduplicationGCModule(), (Object)deduplicationBlobModule);
            }
            case PASSTHROUGH: {
                Module passThroughBlobModule = binder -> binder.bind(BlobStore.class).annotatedWith((Annotation)Names.named((String)"blobStoreBackend")).to(PassThroughBlobStore.class);
                return ImmutableList.of((Object)new BlobStoreAPIModule(), (Object)passThroughBlobModule);
            }
        }
        throw new RuntimeException("Unknown storage strategy " + storageStrategy.name());
    }

    static class CassandraBlobStoreDAODeclarationModule
    extends AbstractModule {
        CassandraBlobStoreDAODeclarationModule() {
        }

        protected void configure() {
            this.install((Module)new CassandraBlobStoreDependenciesModule());
            this.install((Module)new CassandraBucketModule());
            this.bind(BlobStoreDAO.class).annotatedWith((Annotation)Names.named((String)BlobStoreModulesChooser.UNENCRYPTED)).to(CassandraBlobStoreDAO.class);
        }
    }

    static class ObjectStorageBlobStoreDAODeclarationModule
    extends AbstractModule {
        ObjectStorageBlobStoreDAODeclarationModule() {
        }

        protected void configure() {
            this.install((Module)new S3BlobStoreModule());
            this.install((Module)new DefaultBucketModule());
            this.bind(BlobStoreDAO.class).annotatedWith((Annotation)Names.named((String)BlobStoreModulesChooser.UNENCRYPTED)).to(S3BlobStoreDAO.class);
        }
    }

    static class NoEncryptionModule
    extends AbstractModule {
        NoEncryptionModule() {
        }

        @Provides
        @Singleton
        BlobStoreDAO blobStoreDAO(@Named(value="unencrypted") BlobStoreDAO unencrypted) {
            return unencrypted;
        }
    }

    static class EncryptionModule
    extends AbstractModule {
        private final CryptoConfig cryptoConfig;

        EncryptionModule(CryptoConfig cryptoConfig) {
            this.cryptoConfig = cryptoConfig;
        }

        @Provides
        @Singleton
        BlobStoreDAO blobStoreDAO(@Named(value="unencrypted") BlobStoreDAO unencrypted) {
            return new AESBlobStoreDAO(unencrypted, this.cryptoConfig);
        }

        @Provides
        CryptoConfig cryptoConfig() {
            return this.cryptoConfig;
        }
    }
}

