/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.impl.DefaultSPF;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SPF
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPF.class);
    private boolean debug = false;
    private boolean addHeader = false;
    private org.apache.james.jspf.impl.SPF spf;
    public static final AttributeName EXPLANATION_ATTRIBUTE = AttributeName.of((String)"org.apache.james.transport.mailets.spf.explanation");
    public static final AttributeName RESULT_ATTRIBUTE = AttributeName.of((String)"org.apache.james.transport.mailets.spf.result");
    private static final String privateNetworks = "127.0.0.0/8, 10.0.0.0/8, 172.16.0.0/16, 172.17.0.0/16, 172.18.0.0/16, 172.19.0.0/16, 172.20.0.0/16, 172.21.0.0/16, 172.22.0.0/16, 172.23.0.0/16, 172.24.0.0/16, 172.25.0.0/16, 172.26.0.0/16, 172.27.0.0/16, 172.28.0.0/16, 172.29.0.0/16, 172.30.0.0/16, 172.31.0.0/16";
    private final DNSService dnsService;
    private NetMatcher netMatcher;
    private org.apache.james.jspf.core.DNSService spfDnsService;

    @Inject
    public SPF(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    public void setSPFDnsService(org.apache.james.jspf.core.DNSService spfDnsService) {
        this.spfDnsService = spfDnsService;
    }

    public void init() {
        this.debug = Boolean.parseBoolean(this.getInitParameter("debug", "false"));
        this.addHeader = Boolean.parseBoolean(this.getInitParameter("addHeader", "false"));
        this.spf = this.spfDnsService == null ? new DefaultSPF() : new org.apache.james.jspf.impl.SPF(this.spfDnsService);
        List ignoredNetworks = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)this.getInitParameter("ignoredNetworks", privateNetworks));
        this.netMatcher = new NetMatcher((Collection)ignoredNetworks, this.dnsService);
        LOGGER.info("SPF addHeader={} debug={} ignoredNetworks={}", new Object[]{this.addHeader, this.debug, ignoredNetworks});
    }

    public void service(Mail mail) throws MessagingException {
        String remoteAddr = mail.getRemoteAddr();
        if (this.netMatcher.matchInetNetwork(remoteAddr)) {
            LOGGER.debug("ignore SPF check for ip:{}", (Object)remoteAddr);
        } else {
            String helo = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)Mail.SMTP_HELO, String.class).orElse(mail.getRemoteHost());
            String sender = mail.getMaybeSender().asString("");
            SPFResult result = this.spf.checkSPF(remoteAddr, sender, helo);
            mail.setAttribute(new Attribute(EXPLANATION_ATTRIBUTE, AttributeValue.of((String)result.getExplanation())));
            mail.setAttribute(new Attribute(RESULT_ATTRIBUTE, AttributeValue.of((String)result.getResult())));
            LOGGER.debug("ip:{} from:{} helo:{} = {}", new Object[]{remoteAddr, sender, helo, result.getResult()});
            if (this.addHeader) {
                try {
                    MimeMessage msg = mail.getMessage();
                    msg.addHeader(result.getHeaderName(), result.getHeaderText());
                    msg.saveChanges();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
            }
        }
    }
}

